/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import org.apache.commons.lang.StringUtils;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.i18n.LocalizedKeywords;
import org.jbehave.core.io.LoadFromClasspath;
import org.jbehave.core.io.ResourceLoader;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.steps.ParameterConverters;

public class ExamplesTableFactory {
    private final Keywords keywords;
    private final ResourceLoader resourceLoader;
    private final ParameterConverters parameterConverters;

    public ExamplesTableFactory() {
        this(new LocalizedKeywords());
    }

    public ExamplesTableFactory(Keywords keywords) {
        this(keywords, new LoadFromClasspath(), new ParameterConverters());
    }

    public ExamplesTableFactory(ParameterConverters parameterConverters) {
        this(new LocalizedKeywords(), new LoadFromClasspath(), parameterConverters);
    }

    public ExamplesTableFactory(ResourceLoader resourceLoader) {
        this(new LocalizedKeywords(), resourceLoader, new ParameterConverters());
    }

    public ExamplesTableFactory(Keywords keywords, ResourceLoader resourceLoader, ParameterConverters parameterConverters) {
        this.keywords = keywords;
        this.resourceLoader = resourceLoader;
        this.parameterConverters = parameterConverters;
    }

    public ExamplesTable createExamplesTable(String input) {
        String tableAsString = StringUtils.isBlank((String)input) || this.isTable(input) ? input : this.resourceLoader.loadResourceAsText(input);
        return new ExamplesTable(tableAsString, this.keywords.examplesTableHeaderSeparator(), this.keywords.examplesTableValueSeparator(), this.keywords.examplesTableIgnorableSeparator(), this.parameterConverters);
    }

    protected boolean isTable(String input) {
        return input.contains(this.keywords.examplesTableHeaderSeparator());
    }
}

