/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbehave.core.io.StoryLocation;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Narrative;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.StepPattern;
import org.jbehave.core.model.Story;
import org.jbehave.core.reporters.DelegatingStoryReporter;
import org.jbehave.core.reporters.FilePrintStreamFactory;
import org.jbehave.core.reporters.Format;
import org.jbehave.core.reporters.NullStoryReporter;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.reporters.StoryReporterBuilder;
import org.jbehave.core.steps.NullStepMonitor;
import org.jbehave.core.steps.StepMonitor;
import org.jbehave.core.steps.StepType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrossReference
extends Format {
    private final XStream XSTREAM_FOR_XML = new XStream();
    private final XStream XSTREAM_FOR_JSON = new XStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver());
    private ThreadLocal<Story> currentStory = new ThreadLocal();
    private ThreadLocal<Long> currentStoryStart = new ThreadLocal();
    private ThreadLocal<String> currentScenarioTitle = new ThreadLocal();
    private List<StoryHolder> stories = new ArrayList<StoryHolder>();
    private Map<String, Long> times = new HashMap<String, Long>();
    private Map<String, StepMatch> stepMatches = new HashMap<String, StepMatch>();
    private StepMonitor stepMonitor = new XRefStepMonitor();
    private Set<String> failingStories = new HashSet<String>();
    private Set<String> stepsPerformed = new HashSet<String>();
    private boolean doJson = true;
    private boolean doXml = true;
    private boolean excludeStoriesWithNoExecutedScenarios = false;
    private boolean outputAfterEachStory = false;
    private Format threadSafeDelegateFormat;

    public CrossReference() {
        this("XREF");
    }

    public CrossReference(String name) {
        super(name);
        this.configure(this.XSTREAM_FOR_XML);
        this.configure(this.XSTREAM_FOR_JSON);
    }

    public CrossReference withJsonOnly() {
        this.doJson = true;
        this.doXml = false;
        return this;
    }

    public CrossReference withXmlOnly() {
        this.doJson = false;
        this.doXml = true;
        return this;
    }

    public CrossReference withOutputAfterEachStory(boolean outputAfterEachStory) {
        this.outputAfterEachStory = outputAfterEachStory;
        return this;
    }

    public CrossReference withThreadSafeDelegateFormat(Format format) {
        this.threadSafeDelegateFormat = format;
        return this;
    }

    public CrossReference excludingStoriesWithNoExecutedScenarios(boolean exclude) {
        this.excludeStoriesWithNoExecutedScenarios = exclude;
        return this;
    }

    public StepMonitor getStepMonitor() {
        return this.stepMonitor;
    }

    public synchronized void outputToFiles(StoryReporterBuilder storyReporterBuilder) {
        XRefRoot root = this.createXRefRoot(storyReporterBuilder, this.stories, this.failingStories);
        root.addStepMatches(this.stepMatches);
        if (this.doXml) {
            this.outputFile(this.fileName("xml"), this.XSTREAM_FOR_XML, root, storyReporterBuilder);
        }
        if (this.doJson) {
            this.outputFile(this.fileName("json"), this.XSTREAM_FOR_JSON, root, storyReporterBuilder);
        }
    }

    protected String fileName(String extension) {
        return this.name().toLowerCase() + "." + extension;
    }

    protected final XRefRoot createXRefRoot(StoryReporterBuilder storyReporterBuilder, List<StoryHolder> stories, Set<String> failingStories) {
        XRefRoot xrefRoot = this.newXRefRoot();
        xrefRoot.metaFilter = this.getMetaFilter();
        xrefRoot.setExcludeStoriesWithNoExecutedScenarios(this.excludeStoriesWithNoExecutedScenarios);
        xrefRoot.processStories(stories, this.stepsPerformed, this.times, storyReporterBuilder, failingStories);
        return xrefRoot;
    }

    protected XRefRoot newXRefRoot() {
        return new XRefRoot();
    }

    private void outputFile(String name, XStream xstream, XRefRoot root, StoryReporterBuilder storyReporterBuilder) {
        File outputDir = new File(storyReporterBuilder.outputDirectory(), "view");
        outputDir.mkdirs();
        try {
            Writer writer = this.makeWriter(new File(outputDir, name));
            writer.write(xstream.toXML((Object)root));
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            throw new XrefOutputFailed(name, e);
        }
    }

    public String getMetaFilter() {
        return "";
    }

    protected Writer makeWriter(File file) throws IOException {
        return new FileWriter(file);
    }

    private void configure(XStream xstream) {
        xstream.setMode(1001);
        this.aliasForXRefRoot(xstream);
        this.aliasForXRefStory(xstream);
        xstream.alias("stepMatch", StepMatch.class);
        xstream.alias("pattern", StepPattern.class);
        xstream.alias("use", StepUsage.class);
        xstream.omitField(ExamplesTable.class, "parameterConverters");
        xstream.omitField(ExamplesTable.class, "defaults");
    }

    protected void aliasForXRefStory(XStream xstream) {
        xstream.alias("story", XRefStory.class);
    }

    protected void aliasForXRefRoot(XStream xstream) {
        xstream.alias("xref", XRefRoot.class);
    }

    @Override
    public StoryReporter createStoryReporter(FilePrintStreamFactory factory, final StoryReporterBuilder storyReporterBuilder) {
        StoryReporter delegate = this.threadSafeDelegateFormat == null ? new NullStoryReporter() : this.threadSafeDelegateFormat.createStoryReporter(factory, storyReporterBuilder);
        return new DelegatingStoryReporter(new StoryReporter[]{delegate}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void beforeStory(Story story, boolean givenStory) {
                1 var3_3 = this;
                synchronized (var3_3) {
                    CrossReference.this.stories.add(new StoryHolder(story));
                }
                CrossReference.this.currentStory.set(story);
                CrossReference.this.currentStoryStart.set(System.currentTimeMillis());
                super.beforeStory(story, givenStory);
            }

            public void failed(String step, Throwable cause) {
                CrossReference.this.failingStories.add(((Story)CrossReference.this.currentStory.get()).getPath());
                super.failed(step, cause);
            }

            public void afterStory(boolean givenStory) {
                CrossReference.this.times.put(((Story)CrossReference.this.currentStory.get()).getPath(), System.currentTimeMillis() - (Long)CrossReference.this.currentStoryStart.get());
                if (CrossReference.this.outputAfterEachStory) {
                    CrossReference.this.outputToFiles(storyReporterBuilder);
                }
                super.afterStory(givenStory);
            }

            public void beforeScenario(String title) {
                CrossReference.this.currentScenarioTitle.set(title);
                super.beforeScenario(title);
            }
        };
    }

    private class StoryHolder {
        Story story;
        long when;

        private StoryHolder(Story story) {
            this.story = story;
            this.when = System.currentTimeMillis();
        }
    }

    public static class StepMatch {
        private final StepType type;
        private final String annotatedPattern;
        private final String resolvedPattern;
        private final Set<StepUsage> usages = new HashSet<StepUsage>();

        public StepMatch(StepType type, String annotatedPattern, String resolvedPattern) {
            this.type = type;
            this.annotatedPattern = annotatedPattern;
            this.resolvedPattern = resolvedPattern;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StepMatch stepMatch = (StepMatch)o;
            if (this.annotatedPattern != null ? !this.annotatedPattern.equals(stepMatch.annotatedPattern) : stepMatch.annotatedPattern != null) {
                return false;
            }
            return this.type == stepMatch.type;
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + (this.annotatedPattern != null ? this.annotatedPattern.hashCode() : 0);
            return result;
        }
    }

    public static class StepUsage {
        private final String story;
        private final String scenario;
        private final String step;

        public StepUsage(String story, String scenario, String step) {
            this.story = story;
            this.scenario = scenario;
            this.step = step;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XRefStory {
        private transient Story story;
        private String description;
        private String narrative = "";
        private String name;
        private String path;
        private String html;
        private String meta = "";
        private String scenarios = "";
        private boolean passed;
        public long started;
        public long duration;

        public XRefStory(Story story, StoryReporterBuilder storyReporterBuilder, boolean passed) {
            this.story = story;
            Narrative narrative = story.getNarrative();
            if (!narrative.isEmpty()) {
                this.narrative = "In order to " + narrative.inOrderTo() + "\n" + "As a " + narrative.asA() + "\n" + "I want to " + narrative.iWantTo() + "\n";
            }
            this.description = story.getDescription().asString();
            this.name = story.getName();
            this.path = story.getPath();
            this.passed = passed;
            this.html = storyReporterBuilder.pathResolver().resolveName(new StoryLocation(storyReporterBuilder.codeLocation(), story.getPath()), "html");
        }

        protected void processScenarios() {
            for (Scenario scenario : this.story.getScenarios()) {
                String body = "Scenario:" + scenario.getTitle() + "\n";
                List<String> steps = scenario.getSteps();
                for (String step : steps) {
                    body = body + step + "\n";
                }
                this.scenarios = this.scenarios + body + "\n\n";
            }
        }

        protected void processMetaTags(XRefRoot root) {
            Meta storyMeta = this.story.getMeta();
            for (String next : storyMeta.getPropertyNames()) {
                String property = next + "=" + storyMeta.getProperty(next);
                this.addMetaProperty(property, root.meta);
                String newMeta = this.appendMetaProperty(property, this.meta);
                if (newMeta == null) continue;
                this.meta = newMeta;
            }
        }

        protected String appendMetaProperty(String property, String meta) {
            return meta + property + "\n";
        }

        protected void addMetaProperty(String property, Set<String> meta) {
            meta.add(property);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XRefRoot {
        protected long whenMade = System.currentTimeMillis();
        protected String createdBy = this.createdBy();
        protected String metaFilter = "";
        private Set<String> meta = new HashSet<String>();
        private List<XRefStory> stories = new ArrayList<XRefStory>();
        private List<StepMatch> stepMatches = new ArrayList<StepMatch>();
        private transient boolean excludeStoriesWithNoExecutedScenarios;

        public void setExcludeStoriesWithNoExecutedScenarios(boolean exclude) {
            this.excludeStoriesWithNoExecutedScenarios = exclude;
        }

        protected String createdBy() {
            return "JBehave";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processStories(List<StoryHolder> stories, Set<String> stepsPerformed, Map<String, Long> times, StoryReporterBuilder builder, Set<String> failures) {
            XRefRoot xRefRoot = this;
            synchronized (xRefRoot) {
                for (StoryHolder storyHolder : stories) {
                    Story story = storyHolder.story;
                    String path = story.getPath();
                    if (path.equals("BeforeStories") || path.equals("AfterStories") || !this.someScenarios(story, stepsPerformed) && this.excludeStoriesWithNoExecutedScenarios) continue;
                    XRefStory xRefStory = this.createXRefStory(builder, story, !failures.contains(path), this);
                    xRefStory.started = storyHolder.when;
                    xRefStory.duration = this.getTime(times, story);
                    this.stories.add(xRefStory);
                }
            }
        }

        protected Long getTime(Map<String, Long> times, Story story) {
            Long time = times.get(story.getPath());
            if (time == null) {
                return 0L;
            }
            return time;
        }

        protected boolean someScenarios(Story story, Set<String> stepsPerformed) {
            return stepsPerformed.contains(story.getPath());
        }

        protected final XRefStory createXRefStory(StoryReporterBuilder storyReporterBuilder, Story story, boolean passed, XRefRoot root) {
            XRefStory xrefStory = this.createXRefStory(storyReporterBuilder, story, passed);
            xrefStory.processMetaTags(root);
            xrefStory.processScenarios();
            return xrefStory;
        }

        protected XRefStory createXRefStory(StoryReporterBuilder storyReporterBuilder, Story story, boolean passed) {
            return new XRefStory(story, storyReporterBuilder, passed);
        }

        protected void addStepMatches(Map<String, StepMatch> stepMatchMap) {
            for (String key : stepMatchMap.keySet()) {
                StepMatch stepMatch = stepMatchMap.get(key);
                this.stepMatches.add(stepMatch);
            }
        }
    }

    private class XRefStepMonitor
    extends NullStepMonitor {
        private XRefStepMonitor() {
        }

        public void performing(String step, boolean dryRun) {
            super.performing(step, dryRun);
            CrossReference.this.stepsPerformed.add(((Story)CrossReference.this.currentStory.get()).getPath());
        }

        public void stepMatchesPattern(String step, boolean matches, StepPattern pattern, Method method, Object stepsInstance) {
            Story story = (Story)CrossReference.this.currentStory.get();
            if (story == null) {
                throw new NullPointerException("story not setup for CrossReference");
            }
            if (matches) {
                String key = (Object)((Object)pattern.type()) + pattern.annotated();
                StepMatch stepMatch = (StepMatch)CrossReference.this.stepMatches.get(key);
                if (stepMatch == null) {
                    stepMatch = new StepMatch(pattern.type(), pattern.annotated(), pattern.resolved());
                    CrossReference.this.stepMatches.put(key, stepMatch);
                }
                stepMatch.usages.add(new StepUsage(story.getPath(), (String)CrossReference.this.currentScenarioTitle.get(), step));
            }
            super.stepMatchesPattern(step, matches, pattern, method, stepsInstance);
        }
    }

    public static class XrefOutputFailed
    extends RuntimeException {
        public XrefOutputFailed(String name, Throwable cause) {
            super(name, cause);
        }
    }
}

