/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.failures.KnownFailure;
import org.jbehave.core.failures.UUIDExceptionWrapper;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.GivenStories;
import org.jbehave.core.model.GivenStory;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Narrative;
import org.jbehave.core.model.OutcomesTable;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.reporters.StoryReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PrintStreamOutput
implements StoryReporter {
    private static final String EMPTY = "";
    private final Format format;
    private final PrintStream output;
    private final Properties outputPatterns;
    private final Keywords keywords;
    private ThreadLocal<Boolean> reportFailureTrace = new ThreadLocal();
    private ThreadLocal<Boolean> compressFailureTrace = new ThreadLocal();
    private ThreadLocal<Throwable> cause = new ThreadLocal();
    private static Replacement[] REPLACEMENTS = new Replacement[]{new Replacement(Pattern.compile("\\tat sun.reflect.NativeMethodAccessorImpl.invoke0\\(Native Method\\)\\n\\tat sun.reflect.NativeMethodAccessorImpl.invoke\\(NativeMethodAccessorImpl.java:\\d+\\)\\n\\tat sun.reflect.DelegatingMethodAccessorImpl.invoke\\(DelegatingMethodAccessorImpl.java:\\d+\\)\\n\\tat java.lang.reflect.Method.invoke\\(Method.java:\\d+\\)"), "\t(reflection-invoke)"), new Replacement(Pattern.compile("\\tat org.codehaus.groovy.reflection.CachedMethod.invoke\\(CachedMethod.java:\\d+\\)\\n\\tat org.codehaus.groovy.runtime.metaclass.ClosureMetaMethod.invoke\\(ClosureMetaMethod.java:\\d+\\)\\n\\tat org.codehaus.groovy.runtime.callsite.PojoMetaMethodSite\\$PojoMetaMethodSiteNoUnwrapNoCoerce.invoke\\(PojoMetaMethodSite.java:\\d+\\)\\n\\tat org.codehaus.groovy.runtime.callsite.PojoMetaMethodSite.call\\(PojoMetaMethodSite.java:\\d+\\)\\n\\tat org.codehaus.groovy.runtime.callsite.CallSiteArray.defaultCall\\(CallSiteArray.java:\\d+\\)\\n\\tat org.codehaus.groovy.runtime.callsite.AbstractCallSite.call\\(AbstractCallSite.java:\\d+\\)\\n\\tat org.codehaus.groovy.runtime.callsite.AbstractCallSite.call\\(AbstractCallSite.java:\\d+\\)"), "\t(groovy-closure-invoke)"), new Replacement(Pattern.compile("\\tat org.codehaus.groovy.reflection.CachedMethod.invoke\\(CachedMethod.java:\\d+\\)\\n\\tat groovy.lang.MetaMethod.doMethodInvoke\\(MetaMethod.java:\\d+\\)\\n\\tat org.codehaus.groovy.runtime.metaclass.ClosureMetaClass.invokeMethod\\(ClosureMetaClass.java:\\d+\\)\\n\\tat org.codehaus.groovy.runtime.ScriptBytecodeAdapter.invokeMethodOnCurrentN\\(ScriptBytecodeAdapter.java:\\d+\\)"), "\t(groovy-instance-method-invoke)"), new Replacement(Pattern.compile("\\tat org.codehaus.groovy.reflection.CachedMethod.invoke\\(CachedMethod.java:\\d+\\)\n\\tat org.codehaus.groovy.runtime.metaclass.ClosureMetaMethod.invoke\\(ClosureMetaMethod.java:\\d+\\)\n\\tat org.codehaus.groovy.runtime.callsite.PojoMetaMethodSite\\$PojoMetaMethodSiteNoUnwrapNoCoerce.invoke\\(PojoMetaMethodSite.java:\\d+\\)\n\\tat org.codehaus.groovy.runtime.callsite.PojoMetaMethodSite.call\\(PojoMetaMethodSite.java:\\d+\\)\n\\tat org.codehaus.groovy.runtime.callsite.AbstractCallSite.call\\(AbstractCallSite.java:\\d+\\)"), "\t(groovy-abstract-method-invoke)"), new Replacement(Pattern.compile("\\tat org.codehaus.groovy.reflection.CachedMethod.invoke\\(CachedMethod.java:\\d+\\)\\n\\tat groovy.lang.MetaMethod.doMethodInvoke\\(MetaMethod.java:\\d+\\)\\n\\tat groovy.lang.MetaClassImpl.invokeStaticMethod\\(MetaClassImpl.java:\\d+\\)\\n\\tat org.codehaus.groovy.runtime.InvokerHelper.invokeStaticMethod\\(InvokerHelper.java:\\d+\\)\\n\\tat org.codehaus.groovy.runtime.ScriptBytecodeAdapter.invokeStaticMethodN\\(ScriptBytecodeAdapter.java:\\d+\\)"), "\t(groovy-static-method-invoke)"), new Replacement(Pattern.compile("\\tat sun.reflect.NativeConstructorAccessorImpl.newInstance0\\(Native Method\\)\\n\\tat sun.reflect.NativeConstructorAccessorImpl.newInstance\\(NativeConstructorAccessorImpl.java:\\d+\\)\\n\\tat sun.reflect.DelegatingConstructorAccessorImpl.newInstance\\(DelegatingConstructorAccessorImpl.java:\\d+\\)\\n\\tat java.lang.reflect.Constructor.newInstance\\(Constructor.java:\\d+\\)"), "\t(reflection-construct)"), new Replacement(Pattern.compile("\\tat org.codehaus.groovy.runtime.callsite.CallSiteArray.defaultCall(Current|)\\(CallSiteArray.java:\\d+\\)\\n\\tat org.codehaus.groovy.runtime.callsite.AbstractCallSite.call(Current|)\\(AbstractCallSite.java:\\d+\\)\\n\\tat org.codehaus.groovy.runtime.callsite.AbstractCallSite.call(Current|)\\(AbstractCallSite.java:\\d+\\)"), "\t(groovy-call)"), new Replacement(Pattern.compile("\\t\\(reflection\\-invoke\\)\\n\\t\\(groovy\\-"), "\t(groovy-")};

    protected PrintStreamOutput(Format format, PrintStream output, Properties outputPatterns, Keywords keywords, boolean reportFailureTrace, boolean compressFailureTrace) {
        this.format = format;
        this.output = output;
        this.outputPatterns = outputPatterns;
        this.keywords = keywords;
        this.doReportFailureTrace(reportFailureTrace);
        this.doCompressFailureTrace(compressFailureTrace);
    }

    @Override
    public void successful(String step) {
        this.print(this.format("successful", "{0}\n", step));
    }

    @Override
    public void ignorable(String step) {
        this.print(this.format("ignorable", "{0}\n", step));
    }

    @Override
    public void pending(String step) {
        this.print(this.format("pending", "{0} ({1})\n", step, this.keywords.pending()));
    }

    @Override
    public void notPerformed(String step) {
        this.print(this.format("notPerformed", "{0} ({1})\n", step, this.keywords.notPerformed()));
    }

    @Override
    public void failed(String step, Throwable storyFailure) {
        if (!(storyFailure instanceof UUIDExceptionWrapper)) {
            throw new ClassCastException(storyFailure + " should be an instance of UUIDExceptionWrapper");
        }
        this.cause.set(storyFailure.getCause());
        this.print(this.format("failed", "{0} ({1})\n({2})\n", step, this.keywords.failed(), storyFailure.getCause(), ((UUIDExceptionWrapper)storyFailure).getUUID()));
    }

    @Override
    public void failedOutcomes(String step, OutcomesTable table) {
        this.failed(step, table.failureCause());
        this.print(table);
    }

    private void print(OutcomesTable table) {
        this.print(this.format("outcomesTableStart", "\n", new Object[0]));
        List<OutcomesTable.Outcome<?>> rows = table.getOutcomes();
        this.print(this.format("outcomesTableHeadStart", "|", new Object[0]));
        for (String string : table.getOutcomeFields()) {
            this.print(this.format("outcomesTableHeadCell", "{0}|", string));
        }
        this.print(this.format("outcomesTableHeadEnd", "\n", new Object[0]));
        this.print(this.format("outcomesTableBodyStart", EMPTY, new Object[0]));
        for (OutcomesTable.Outcome outcome : rows) {
            this.print(this.format("outcomesTableRowStart", "|", outcome.isVerified() ? "verified" : "notVerified"));
            this.print(this.format("outcomesTableCell", "{0}|", outcome.getDescription()));
            this.print(this.format("outcomesTableCell", "{0}|", outcome.getValue()));
            this.print(this.format("outcomesTableCell", "{0}|", outcome.getMatcher()));
            this.print(this.format("outcomesTableCell", "{0}|", outcome.isVerified()));
            this.print(this.format("outcomesTableRowEnd", "\n", new Object[0]));
        }
        this.print(this.format("outcomesTableBodyEnd", "\n", new Object[0]));
        this.print(this.format("outcomesTableEnd", "\n", new Object[0]));
    }

    @Override
    public void storyNotAllowed(Story story, String filter) {
        this.print(this.format("filter", "{0}\n", filter));
    }

    @Override
    public void beforeStory(Story story, boolean givenStory) {
        this.print(this.format("beforeStory", "{0}\n({1})\n", story.getDescription().asString(), story.getPath()));
        if (!story.getMeta().isEmpty()) {
            Meta meta = story.getMeta();
            this.print(meta);
        }
    }

    @Override
    public void narrative(Narrative narrative) {
        if (!narrative.isEmpty()) {
            this.print(this.format("narrative", "{0}\n{1} {2}\n{3} {4}\n{5} {6}\n", this.keywords.narrative(), this.keywords.inOrderTo(), narrative.inOrderTo(), this.keywords.asA(), narrative.asA(), this.keywords.iWantTo(), narrative.iWantTo()));
        }
    }

    private void print(Meta meta) {
        this.print(this.format("metaStart", "{0}\n", this.keywords.meta()));
        for (String name : meta.getPropertyNames()) {
            this.print(this.format("metaProperty", "{0}{1} {2}", this.keywords.metaProperty(), name, meta.getProperty(name)));
        }
        this.print(this.format("metaEnd", "\n", new Object[0]));
    }

    @Override
    public void afterStory(boolean givenStory) {
        this.print(this.format("afterStory", "\n", new Object[0]));
    }

    @Override
    public void givenStories(GivenStories givenStories) {
        this.print(this.format("givenStoriesStart", "{0}\n", this.keywords.givenStories()));
        for (GivenStory givenStory : givenStories.getStories()) {
            this.print(this.format("givenStory", "{0} {1}\n", givenStory.asString(), givenStory.hasAnchor() ? givenStory.getParameters() : EMPTY));
        }
        this.print(this.format("givenStoriesEnd", "\n", new Object[0]));
    }

    @Override
    public void givenStories(List<String> storyPaths) {
        this.givenStories(new GivenStories(StringUtils.join(storyPaths, (String)",")));
    }

    @Override
    public void scenarioNotAllowed(Scenario scenario, String filter) {
        this.print(this.format("filter", "{0}\n", filter));
    }

    @Override
    public void beforeScenario(String title) {
        this.cause.set(null);
        this.print(this.format("beforeScenario", "{0} {1}\n", this.keywords.scenario(), title));
    }

    @Override
    public void scenarioMeta(Meta meta) {
        if (!meta.isEmpty()) {
            this.print(meta);
        }
    }

    @Override
    public void afterScenario() {
        if (this.cause.get() != null && this.reportFailureTrace.get().booleanValue() && !(this.cause.get() instanceof KnownFailure)) {
            this.print(this.format("afterScenarioWithFailure", "\n{0}\n", this.stackTrace(this.cause.get())));
        } else {
            this.print(this.format("afterScenario", "\n", new Object[0]));
        }
    }

    private String stackTrace(Throwable cause) {
        if (cause.getClass().getName().equals(UUIDExceptionWrapper.class.getName())) {
            cause = cause.getCause();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        cause.printStackTrace(new PrintStream(out));
        return this.stackTrace(out.toString());
    }

    protected String stackTrace(String stackTrace) {
        if (!this.compressFailureTrace.get().booleanValue()) {
            return stackTrace;
        }
        stackTrace = this.cutOff(stackTrace, "org.jbehave.core.embedder.");
        stackTrace = this.cutOff(stackTrace, "org.junit.runners.");
        stackTrace = this.cutOff(stackTrace, "org.apache.maven.surefire.");
        for (Replacement replacement : REPLACEMENTS) {
            stackTrace = replacement.from.matcher(stackTrace).replaceAll(replacement.to);
        }
        return stackTrace;
    }

    private String cutOff(String stackTrace, String at) {
        if (stackTrace.indexOf(at) > -1) {
            int ix = stackTrace.indexOf(at);
            if ((ix = stackTrace.indexOf("\n", ix)) != -1) {
                stackTrace = stackTrace.substring(0, ix);
            }
        }
        return stackTrace;
    }

    @Override
    public void beforeExamples(List<String> steps, ExamplesTable table) {
        this.print(this.format("beforeExamples", "{0}\n", this.keywords.examplesTable()));
        for (String step : steps) {
            this.print(this.format("examplesStep", "{0}\n", step));
        }
        this.print(this.formatTable(table));
    }

    @Override
    public void example(Map<String, String> tableRow) {
        this.print(this.format("example", "\n{0} {1}\n", this.keywords.examplesTableRow(), tableRow));
    }

    @Override
    public void afterExamples() {
        this.print(this.format("afterExamples", "\n", new Object[0]));
    }

    @Override
    public void dryRun() {
        this.print(this.format("dryRun", "{0}\n", this.keywords.dryRun()));
    }

    @Override
    public void pendingMethods(List<String> methods) {
        for (String method : methods) {
            this.print(this.format("pendingMethod", "{0}\n", method));
        }
    }

    protected String format(String key, String defaultPattern, Object ... args) {
        return MessageFormat.format(this.lookupPattern(key, this.escape(defaultPattern)), this.escapeAll(args));
    }

    protected String formatTable(ExamplesTable table) {
        ByteArrayOutputStream formatted = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(formatted);
        out.print(this.format("examplesTableStart", "\n", new Object[0]));
        List<Map<String, String>> rows = table.getRows();
        List<String> headers = table.getHeaders();
        out.print(this.format("examplesTableHeadStart", "|", new Object[0]));
        for (String string : headers) {
            out.print(this.format("examplesTableHeadCell", "{0}|", string));
        }
        out.print(this.format("examplesTableHeadEnd", "\n", new Object[0]));
        out.print(this.format("examplesTableBodyStart", EMPTY, new Object[0]));
        for (Map map : rows) {
            out.print(this.format("examplesTableRowStart", "|", new Object[0]));
            for (String header : headers) {
                out.print(this.format("examplesTableCell", "{0}|", map.get(header)));
            }
            out.print(this.format("examplesTableRowEnd", "\n", new Object[0]));
        }
        out.print(this.format("examplesTableBodyEnd", EMPTY, new Object[0]));
        out.print(this.format("examplesTableEnd", EMPTY, new Object[0]));
        return ((Object)formatted).toString();
    }

    private String escape(String defaultPattern) {
        return (String)this.escapeAll(defaultPattern)[0];
    }

    private Object[] escapeAll(Object ... args) {
        return this.escape(this.format, args);
    }

    protected Object[] escape(final Format format, Object ... args) {
        Transformer escapingTransformer = new Transformer(){

            public Object transform(Object object) {
                switch (format) {
                    case HTML: {
                        return StringEscapeUtils.escapeHtml((String)this.asString(object));
                    }
                    case XML: {
                        return StringEscapeUtils.escapeXml((String)this.asString(object));
                    }
                }
                return object;
            }

            private String asString(Object object) {
                return object != null ? object.toString() : PrintStreamOutput.EMPTY;
            }
        };
        List<Object> list = Arrays.asList(ArrayUtils.clone((Object[])args));
        CollectionUtils.transform(list, (Transformer)escapingTransformer);
        return list.toArray();
    }

    protected String lookupPattern(String key, String defaultPattern) {
        if (this.outputPatterns.containsKey(key)) {
            return this.outputPatterns.getProperty(key);
        }
        return defaultPattern;
    }

    public boolean reportFailureTrace() {
        return this.reportFailureTrace.get();
    }

    public PrintStreamOutput doReportFailureTrace(boolean reportFailureTrace) {
        this.reportFailureTrace.set(reportFailureTrace);
        return this;
    }

    public boolean compressFailureTrace() {
        return this.compressFailureTrace.get();
    }

    public PrintStreamOutput doCompressFailureTrace(boolean compressFailureTrace) {
        this.compressFailureTrace.set(compressFailureTrace);
        return this;
    }

    protected void overwritePattern(String key, String pattern) {
        this.outputPatterns.put(key, pattern);
    }

    protected void print(String text) {
        if (this.containsTable(text)) {
            String tableStart = this.format("\uff3b", "\uff3b", new Object[0]);
            String tableEnd = this.format("\uff3d", "\uff3d", new Object[0]);
            String tableAsString = StringUtils.substringBetween((String)text, (String)tableStart, (String)tableEnd);
            this.output.print(text.replace(tableAsString, this.formatTable(new ExamplesTable(tableAsString))).replace(tableStart, this.format("parameterValueStart", EMPTY, new Object[0])).replace(tableEnd, this.format("parameterValueEnd", EMPTY, new Object[0])).replace(this.format("\u2424", "\u2424", new Object[0]), this.format("parameterValueNewline", "\n", new Object[0])));
        } else {
            this.output.print(text.replace(this.format("\uff5f", "\uff5f", new Object[0]), this.format("parameterValueStart", EMPTY, new Object[0])).replace(this.format("\uff60", "\uff60", new Object[0]), this.format("parameterValueEnd", EMPTY, new Object[0])).replace(this.format("\u2424", "\u2424", new Object[0]), this.format("parameterValueNewline", "\n", new Object[0])));
        }
    }

    private boolean containsTable(String text) {
        String tableStart = this.format("\uff3b", "\uff3b", new Object[0]);
        String tableEnd = this.format("\uff3d", "\uff3d", new Object[0]);
        return text.contains(tableStart) && text.contains(tableEnd);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.format).append((Object)this.output).toString();
    }

    private static class Replacement {
        private final Pattern from;
        private final String to;

        private Replacement(Pattern from, String to) {
            this.from = from;
            this.to = to;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        TXT,
        HTML,
        XML;

    }
}

