/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.i18n.LocalizedKeywords;
import org.jbehave.core.io.CodeLocations;
import org.jbehave.core.io.StoryLocation;
import org.jbehave.core.reporters.ConcurrentStoryReporter;
import org.jbehave.core.reporters.CrossReference;
import org.jbehave.core.reporters.DelegatingStoryReporter;
import org.jbehave.core.reporters.FilePrintStreamFactory;
import org.jbehave.core.reporters.FreemarkerViewGenerator;
import org.jbehave.core.reporters.NullStoryReporter;
import org.jbehave.core.reporters.StoryReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryReporterBuilder {
    private List<org.jbehave.core.reporters.Format> formats = new ArrayList<org.jbehave.core.reporters.Format>();
    private String relativeDirectory = new FilePrintStreamFactory.FileConfiguration().getRelativeDirectory();
    private FilePrintStreamFactory.FilePathResolver pathResolver = new FilePrintStreamFactory.FileConfiguration().getPathResolver();
    private URL codeLocation = CodeLocations.codeLocationFromPath("target/classes");
    private Properties viewResources = FreemarkerViewGenerator.defaultViewProperties();
    private boolean reportFailureTrace = false;
    private boolean compressFailureTrace = false;
    private Keywords keywords = new LocalizedKeywords();
    private CrossReference crossReference;
    private boolean multiThreading;

    public File outputDirectory() {
        return this.filePrintStreamFactory("").outputDirectory();
    }

    public String relativeDirectory() {
        return this.relativeDirectory;
    }

    public FilePrintStreamFactory.FilePathResolver pathResolver() {
        return this.pathResolver;
    }

    public URL codeLocation() {
        return this.codeLocation;
    }

    public List<org.jbehave.core.reporters.Format> formats() {
        return this.formats;
    }

    public List<String> formatNames(boolean toLowerCase) {
        Locale locale = Locale.getDefault();
        if (this.keywords instanceof LocalizedKeywords) {
            locale = ((LocalizedKeywords)this.keywords).getLocale();
        }
        ArrayList<String> names = new ArrayList<String>();
        for (org.jbehave.core.reporters.Format format : this.formats) {
            String name = format.name();
            if (toLowerCase) {
                name = name.toLowerCase(locale);
            }
            names.add(name);
        }
        return names;
    }

    public Keywords keywords() {
        return this.keywords;
    }

    public boolean multiThreading() {
        return this.multiThreading;
    }

    public boolean reportFailureTrace() {
        return this.reportFailureTrace;
    }

    public boolean compressFailureTrace() {
        return this.compressFailureTrace;
    }

    public Properties viewResources() {
        return this.viewResources;
    }

    public StoryReporterBuilder withRelativeDirectory(String relativeDirectory) {
        this.relativeDirectory = relativeDirectory;
        return this;
    }

    public StoryReporterBuilder withPathResolver(FilePrintStreamFactory.FilePathResolver pathResolver) {
        this.pathResolver = pathResolver;
        return this;
    }

    public StoryReporterBuilder withCodeLocation(URL codeLocation) {
        this.codeLocation = codeLocation;
        return this;
    }

    public CrossReference crossReference() {
        return this.crossReference;
    }

    public boolean hasCrossReference() {
        return this.crossReference != null;
    }

    public StoryReporterBuilder withCrossReference(CrossReference crossReference) {
        this.crossReference = crossReference;
        return this;
    }

    public StoryReporterBuilder withDefaultFormats() {
        return this.withFormats(Format.STATS);
    }

    @Deprecated
    public StoryReporterBuilder withFormats(Format ... formats) {
        ArrayList<org.jbehave.core.reporters.Format> formatz = new ArrayList<org.jbehave.core.reporters.Format>();
        for (Format format : formats) {
            formatz.add(format.realFormat);
        }
        this.formats.addAll(formatz);
        return this;
    }

    public StoryReporterBuilder withFormats(org.jbehave.core.reporters.Format ... formats) {
        this.formats.addAll(Arrays.asList(formats));
        return this;
    }

    public StoryReporterBuilder withFailureTrace(boolean reportFailureTrace) {
        this.reportFailureTrace = reportFailureTrace;
        return this;
    }

    public StoryReporterBuilder withFailureTraceCompression(boolean compressFailureTrace) {
        this.compressFailureTrace = compressFailureTrace;
        return this;
    }

    public StoryReporterBuilder withKeywords(Keywords keywords) {
        this.keywords = keywords;
        return this;
    }

    public StoryReporterBuilder withMultiThreading(boolean multiThreading) {
        this.multiThreading = multiThreading;
        return this;
    }

    public StoryReporterBuilder withViewResources(Properties resources) {
        this.viewResources = resources;
        return this;
    }

    public StoryReporter build(String storyPath) {
        HashMap<org.jbehave.core.reporters.Format, StoryReporter> delegates = new HashMap<org.jbehave.core.reporters.Format, StoryReporter>();
        for (org.jbehave.core.reporters.Format format : this.formats) {
            delegates.put(format, this.reporterFor(storyPath, format));
        }
        DelegatingStoryReporter delegate = new DelegatingStoryReporter(delegates.values());
        NullStoryReporter crossReferencing = this.crossReference == null ? new NullStoryReporter() : this.reporterFor(storyPath, this.crossReference);
        return new ConcurrentStoryReporter(crossReferencing, delegate, this.multiThreading);
    }

    public Map<String, StoryReporter> build(List<String> storyPaths) {
        HashMap<String, StoryReporter> reporters = new HashMap<String, StoryReporter>();
        for (String storyPath : storyPaths) {
            reporters.put(storyPath, this.build(storyPath));
        }
        reporters.put("*", this.build("*"));
        return reporters;
    }

    public StoryReporter reporterFor(String storyPath, Format format) {
        FilePrintStreamFactory factory = this.filePrintStreamFactory(storyPath);
        return format.realFormat.createStoryReporter(factory, this);
    }

    public StoryReporter reporterFor(String storyPath, org.jbehave.core.reporters.Format format) {
        FilePrintStreamFactory factory = this.filePrintStreamFactory(storyPath);
        return format.createStoryReporter(factory, this);
    }

    protected FilePrintStreamFactory filePrintStreamFactory(String storyPath) {
        return new FilePrintStreamFactory(new StoryLocation(this.codeLocation, storyPath), this.fileConfiguration(""));
    }

    public FilePrintStreamFactory.FileConfiguration fileConfiguration(String extension) {
        return new FilePrintStreamFactory.FileConfiguration(this.relativeDirectory, extension, this.pathResolver);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        CONSOLE(org.jbehave.core.reporters.Format.CONSOLE),
        IDE_CONSOLE(org.jbehave.core.reporters.Format.IDE_CONSOLE),
        TXT(org.jbehave.core.reporters.Format.TXT),
        HTML(org.jbehave.core.reporters.Format.HTML),
        XML(org.jbehave.core.reporters.Format.XML),
        STATS(org.jbehave.core.reporters.Format.STATS);

        private org.jbehave.core.reporters.Format realFormat;

        private Format(org.jbehave.core.reporters.Format realFormat) {
            this.realFormat = realFormat;
        }
    }
}

