/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.lang.reflect.Method;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jbehave.core.failures.PendingStepFound;
import org.jbehave.core.failures.UUIDExceptionWrapper;
import org.jbehave.core.model.OutcomesTable;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.steps.StepResult;

public abstract class AbstractStepResult
implements StepResult {
    protected final String step;
    private String parametrisedStep;
    protected final UUIDExceptionWrapper throwable;

    public AbstractStepResult(String step) {
        this(step, null);
    }

    public AbstractStepResult(String step, UUIDExceptionWrapper throwable) {
        this.step = step;
        this.throwable = throwable;
    }

    public String parametrisedStep() {
        return this.parametrisedStep != null ? this.parametrisedStep : this.step;
    }

    public StepResult withParameterValues(String parametrisedStep) {
        this.parametrisedStep = parametrisedStep;
        return this;
    }

    public UUIDExceptionWrapper getFailure() {
        return this.throwable;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.parametrisedStep()).toString();
    }

    public static StepResult successful(String step) {
        return new Successful(step);
    }

    public static StepResult ignorable(String step) {
        return new Ignorable(step);
    }

    public static StepResult pending(String step) {
        return new Pending(step);
    }

    public static StepResult pending(String step, PendingStepFound e) {
        return new Pending(step, e);
    }

    public static StepResult notPerformed(String step) {
        return new NotPerformed(step);
    }

    public static StepResult failed(String step, UUIDExceptionWrapper e) {
        return new Failed(step, e);
    }

    public static StepResult failed(Method method, UUIDExceptionWrapper e) {
        return new Failed(method, e);
    }

    public static StepResult skipped() {
        return new Skipped();
    }

    public static class Skipped
    extends AbstractStepResult {
        public Skipped() {
            super("");
        }

        public void describeTo(StoryReporter reporter) {
        }
    }

    public static class Ignorable
    extends AbstractStepResult {
        public Ignorable(String step) {
            super(step);
        }

        public void describeTo(StoryReporter reporter) {
            reporter.ignorable(this.step);
        }
    }

    public static class Successful
    extends AbstractStepResult {
        public Successful(String string) {
            super(string);
        }

        public void describeTo(StoryReporter reporter) {
            reporter.successful(this.parametrisedStep());
        }
    }

    public static class Pending
    extends AbstractStepResult {
        public Pending(String step) {
            this(step, new PendingStepFound(step));
        }

        public Pending(String step, PendingStepFound e) {
            super(step, e);
        }

        public void describeTo(StoryReporter reporter) {
            reporter.pending(this.parametrisedStep());
        }
    }

    public static class NotPerformed
    extends AbstractStepResult {
        public NotPerformed(String step) {
            super(step);
        }

        public void describeTo(StoryReporter reporter) {
            reporter.notPerformed(this.parametrisedStep());
        }
    }

    public static class Failed
    extends AbstractStepResult {
        public Failed(String step, UUIDExceptionWrapper throwable) {
            super(step, throwable);
        }

        public Failed(Method method, UUIDExceptionWrapper throwable) {
            super(Failed.asString(method), throwable);
        }

        private static String asString(Method method) {
            return method != null ? method.toGenericString() : "";
        }

        public void describeTo(StoryReporter reporter) {
            if (this.throwable instanceof OutcomesTable.OutcomesFailed) {
                reporter.failedOutcomes(this.parametrisedStep(), ((OutcomesTable.OutcomesFailed)this.throwable).outcomesTable());
            } else {
                reporter.failed(this.parametrisedStep(), this.throwable);
            }
        }
    }
}

