/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.jbehave.core.annotations.AsParameterConverter;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.ParameterConverters;
import org.jbehave.core.steps.Steps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStepsFactory
implements InjectableStepsFactory {
    private final Configuration configuration;

    public AbstractStepsFactory(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public List<CandidateSteps> createCandidateSteps() {
        List<Object> stepsInstances = this.stepsInstances();
        ArrayList<CandidateSteps> steps = new ArrayList<CandidateSteps>();
        for (Object instance : stepsInstances) {
            this.configuration.parameterConverters().addConverters(this.methodReturningConverters(instance));
            steps.add(new Steps(this.configuration, instance));
        }
        return steps;
    }

    protected abstract List<Object> stepsInstances();

    private List<ParameterConverters.ParameterConverter> methodReturningConverters(Object instance) {
        ArrayList<ParameterConverters.ParameterConverter> converters = new ArrayList<ParameterConverters.ParameterConverter>();
        for (Method method : instance.getClass().getMethods()) {
            if (!method.isAnnotationPresent(AsParameterConverter.class)) continue;
            converters.add(new ParameterConverters.MethodReturningConverter(method, instance));
        }
        return converters;
    }

    protected boolean hasAnnotatedMethods(Type type) {
        if (type instanceof Class) {
            for (Method method : ((Class)type).getMethods()) {
                for (Annotation annotation : method.getAnnotations()) {
                    if (!annotation.annotationType().getName().startsWith("org.jbehave.core.annotations")) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

