/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.lang.reflect.Method;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.steps.SilentStepMonitor;
import org.jbehave.core.steps.Step;
import org.jbehave.core.steps.StepCollector;
import org.jbehave.core.steps.StepCreator;
import org.jbehave.core.steps.StepMonitor;

public class BeforeOrAfterStep {
    private final StepCollector.Stage stage;
    private final Method method;
    private final StepCreator stepCreator;
    private final AfterScenario.Outcome outcome;
    private StepMonitor stepMonitor = new SilentStepMonitor();

    public BeforeOrAfterStep(StepCollector.Stage stage, Method method, Object instance) {
        this(stage, method, instance, AfterScenario.Outcome.ANY);
    }

    public BeforeOrAfterStep(StepCollector.Stage stage, Method method, Object instance, AfterScenario.Outcome outcome) {
        this.stage = stage;
        this.method = method;
        this.outcome = outcome;
        this.stepCreator = new StepCreator(instance, this.stepMonitor);
    }

    public StepCollector.Stage getStage() {
        return this.stage;
    }

    public Method getMethod() {
        return this.method;
    }

    public Step createStep() {
        return this.stepCreator.createBeforeOrAfterStep(this.method);
    }

    public Step createStepUponOutcome(boolean failureOccured) {
        return this.stepCreator.createAfterStepUponOutcome(this.method, this.outcome, failureOccured);
    }

    public void useStepMonitor(StepMonitor stepMonitor) {
        this.stepMonitor = stepMonitor;
        this.stepCreator.useStepMonitor(stepMonitor);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.stage).append((Object)this.method).append((Object)this.outcome).append((Object)this.stepMonitor).toString();
    }
}

