/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.BooleanUtils;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.ExamplesTableFactory;
import org.jbehave.core.steps.SilentStepMonitor;
import org.jbehave.core.steps.StepMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterConverters {
    static final Locale DEFAULT_NUMBER_FORMAT_LOCAL = Locale.ENGLISH;
    static final String DEFAULT_COMMA = ",";
    static final String DEFAULT_TRUE_VALUE = "true";
    static final String DEFAULT_FALSE_VALUE = "false";
    private static final String NEWLINES_PATTERN = "(\n)|(\r\n)";
    private static final String SYSTEM_NEWLINE = System.getProperty("line.separator");
    private final StepMonitor monitor;
    private final List<ParameterConverter> converters = new ArrayList<ParameterConverter>();

    public ParameterConverters() {
        this(new SilentStepMonitor());
    }

    public ParameterConverters(StepMonitor monitor) {
        this(monitor, DEFAULT_NUMBER_FORMAT_LOCAL, DEFAULT_COMMA);
    }

    public ParameterConverters(StepMonitor monitor, Locale locale, String listSeparator) {
        this.monitor = monitor;
        this.addConverters(this.defaultConverters(locale, listSeparator));
    }

    protected ParameterConverter[] defaultConverters(Locale locale, String listSeparator) {
        String escapedListSeparator = this.escapeRegexPunctuation(listSeparator);
        ParameterConverter[] defaultConverters = new ParameterConverter[]{new BooleanConverter(), new NumberConverter(NumberFormat.getInstance(locale)), new NumberListConverter(NumberFormat.getInstance(locale), escapedListSeparator), new StringListConverter(escapedListSeparator), new DateConverter(), new ExamplesTableConverter(new ExamplesTableFactory(this))};
        return defaultConverters;
    }

    private String escapeRegexPunctuation(String matchThis) {
        return matchThis.replaceAll("([\\[\\]\\{\\}\\?\\^\\.\\*\\(\\)\\+\\\\])", "\\\\$1");
    }

    public ParameterConverters addConverters(ParameterConverter ... converters) {
        return this.addConverters(Arrays.asList(converters));
    }

    public ParameterConverters addConverters(List<ParameterConverter> converters) {
        this.converters.addAll(0, converters);
        return this;
    }

    public Object convert(String value, Type type) {
        for (ParameterConverter converter : this.converters) {
            if (!converter.accept(type)) continue;
            Object converted = converter.convertValue(value, type);
            this.monitor.convertedValueOfType(value, type, converted, converter.getClass());
            return converted;
        }
        if (type == String.class) {
            return this.replaceNewlinesWithSystemNewlines(value);
        }
        throw new ParameterConvertionFailed("No parameter converter for " + type);
    }

    private Object replaceNewlinesWithSystemNewlines(String value) {
        return value.replaceAll(NEWLINES_PATTERN, SYSTEM_NEWLINE);
    }

    public static List<String> trim(List<String> values) {
        ArrayList<String> trimmed = new ArrayList<String>();
        for (String value : values) {
            trimmed.add(value.trim());
        }
        return trimmed;
    }

    public static class MethodReturningConverter
    implements ParameterConverter {
        private Object instance;
        private Method method;

        public MethodReturningConverter(Method method, Object instance) {
            this.method = method;
            this.instance = instance;
        }

        public boolean accept(Type type) {
            if (type instanceof Class) {
                return this.method.getReturnType().isAssignableFrom((Class)type);
            }
            return false;
        }

        public Object convertValue(String value, Type type) {
            try {
                return this.method.invoke(this.instance, value);
            }
            catch (Exception e) {
                throw new ParameterConvertionFailed("Failed to invoke method " + this.method + " with value " + value + " in " + this.instance, e);
            }
        }
    }

    public static class ExamplesTableConverter
    implements ParameterConverter {
        private final ExamplesTableFactory factory;

        public ExamplesTableConverter() {
            this(new ExamplesTableFactory());
        }

        public ExamplesTableConverter(ExamplesTableFactory factory) {
            this.factory = factory;
        }

        public boolean accept(Type type) {
            if (type instanceof Class) {
                return ExamplesTable.class.isAssignableFrom((Class)type);
            }
            return false;
        }

        public Object convertValue(String value, Type type) {
            return this.factory.createExamplesTable(value);
        }
    }

    public static class EnumListConverter
    implements ParameterConverter {
        private final EnumConverter enumConverter = new EnumConverter();
        private String valueSeparator;

        public EnumListConverter() {
            this(ParameterConverters.DEFAULT_COMMA);
        }

        public EnumListConverter(String valueSeparator) {
            this.valueSeparator = valueSeparator;
        }

        public boolean accept(Type type) {
            if (type instanceof ParameterizedType) {
                Type rawType = this.rawType(type);
                Type argumentType = this.argumentType(type);
                return List.class.isAssignableFrom((Class)rawType) && this.enumConverter.accept(argumentType);
            }
            return false;
        }

        public Object convertValue(String value, Type type) {
            Type argumentType = this.argumentType(type);
            List<String> values = ParameterConverters.trim(Arrays.asList(value.split(this.valueSeparator)));
            ArrayList<Enum> enums = new ArrayList<Enum>();
            for (String string : values) {
                enums.add((Enum)this.enumConverter.convertValue(string, argumentType));
            }
            return enums;
        }

        private Type rawType(Type type) {
            return ((ParameterizedType)type).getRawType();
        }

        private Type argumentType(Type type) {
            return ((ParameterizedType)type).getActualTypeArguments()[0];
        }
    }

    public static class EnumConverter
    implements ParameterConverter {
        public boolean accept(Type type) {
            if (type instanceof Class) {
                return ((Class)type).isEnum();
            }
            return false;
        }

        public Object convertValue(String value, Type type) {
            String typeClass = ((Class)type).getName();
            Class enumClass = (Class)type;
            Method valueOfMethod = null;
            try {
                valueOfMethod = enumClass.getMethod("valueOf", String.class);
                return valueOfMethod.invoke((Object)enumClass, value);
            }
            catch (Exception e) {
                throw new ParameterConvertionFailed("Failed to convert " + value + " for Enum " + typeClass, e);
            }
        }
    }

    public static class BooleanListConverter
    implements ParameterConverter {
        private final BooleanConverter booleanConverter;
        private String valueSeparator;

        public BooleanListConverter() {
            this(ParameterConverters.DEFAULT_COMMA, ParameterConverters.DEFAULT_TRUE_VALUE, ParameterConverters.DEFAULT_FALSE_VALUE);
        }

        public BooleanListConverter(String valueSeparator) {
            this(valueSeparator, ParameterConverters.DEFAULT_TRUE_VALUE, ParameterConverters.DEFAULT_FALSE_VALUE);
        }

        public BooleanListConverter(String valueSeparator, String trueValue, String falseValue) {
            this.valueSeparator = valueSeparator;
            this.booleanConverter = new BooleanConverter(trueValue, falseValue);
        }

        public boolean accept(Type type) {
            if (type instanceof ParameterizedType) {
                Type rawType = this.rawType(type);
                Type argumentType = this.argumentType(type);
                return List.class.isAssignableFrom((Class)rawType) && Boolean.class.isAssignableFrom((Class)argumentType);
            }
            return false;
        }

        public Object convertValue(String value, Type type) {
            List<String> values = ParameterConverters.trim(Arrays.asList(value.split(this.valueSeparator)));
            ArrayList<Boolean> booleans = new ArrayList<Boolean>();
            for (String booleanValue : values) {
                booleans.add((Boolean)this.booleanConverter.convertValue(booleanValue, type));
            }
            return booleans;
        }

        private Type rawType(Type type) {
            return ((ParameterizedType)type).getRawType();
        }

        private Type argumentType(Type type) {
            return ((ParameterizedType)type).getActualTypeArguments()[0];
        }
    }

    public static class BooleanConverter
    implements ParameterConverter {
        private String trueValue;
        private String falseValue;

        public BooleanConverter() {
            this(ParameterConverters.DEFAULT_TRUE_VALUE, ParameterConverters.DEFAULT_FALSE_VALUE);
        }

        public BooleanConverter(String trueValue, String falseValue) {
            this.trueValue = trueValue;
            this.falseValue = falseValue;
        }

        public boolean accept(Type type) {
            if (type instanceof Class) {
                return Boolean.class.isAssignableFrom((Class)type);
            }
            return false;
        }

        public Object convertValue(String value, Type type) {
            return BooleanUtils.toBoolean((String)value, (String)this.trueValue, (String)this.falseValue);
        }
    }

    public static class DateConverter
    implements ParameterConverter {
        public static final DateFormat DEFAULT_FORMAT = new SimpleDateFormat("dd/MM/yyyy");
        private final DateFormat dateFormat;

        public DateConverter() {
            this(DEFAULT_FORMAT);
        }

        public DateConverter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public boolean accept(Type type) {
            if (type instanceof Class) {
                return Date.class.isAssignableFrom((Class)type);
            }
            return false;
        }

        public Object convertValue(String value, Type type) {
            try {
                return this.dateFormat.parse(value);
            }
            catch (ParseException e) {
                throw new ParameterConvertionFailed("Failed to convert value " + value + " with date format " + (this.dateFormat instanceof SimpleDateFormat ? ((SimpleDateFormat)this.dateFormat).toPattern() : this.dateFormat), e);
            }
        }
    }

    public static class StringListConverter
    implements ParameterConverter {
        private String valueSeparator;

        public StringListConverter() {
            this(ParameterConverters.DEFAULT_COMMA);
        }

        public StringListConverter(String valueSeparator) {
            this.valueSeparator = valueSeparator;
        }

        public boolean accept(Type type) {
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Type rawType = parameterizedType.getRawType();
                Type argumentType = parameterizedType.getActualTypeArguments()[0];
                return List.class.isAssignableFrom((Class)rawType) && String.class.isAssignableFrom((Class)argumentType);
            }
            return false;
        }

        public Object convertValue(String value, Type type) {
            if (value.trim().length() == 0) {
                return Arrays.asList(new Object[0]);
            }
            return ParameterConverters.trim(Arrays.asList(value.split(this.valueSeparator)));
        }
    }

    public static class NumberListConverter
    implements ParameterConverter {
        private final NumberConverter numberConverter;
        private final String valueSeparator;

        public NumberListConverter() {
            this(NumberFormat.getInstance(DEFAULT_NUMBER_FORMAT_LOCAL), ParameterConverters.DEFAULT_COMMA);
        }

        public NumberListConverter(NumberFormat numberFormat, String valueSeparator) {
            this.numberConverter = new NumberConverter(numberFormat);
            this.valueSeparator = valueSeparator;
        }

        public boolean accept(Type type) {
            if (type instanceof ParameterizedType) {
                Type rawType = this.rawType(type);
                Type argumentType = this.argumentType(type);
                return List.class.isAssignableFrom((Class)rawType) && Number.class.isAssignableFrom((Class)argumentType);
            }
            return false;
        }

        private Type rawType(Type type) {
            return ((ParameterizedType)type).getRawType();
        }

        private Type argumentType(Type type) {
            return ((ParameterizedType)type).getActualTypeArguments()[0];
        }

        public Object convertValue(String value, Type type) {
            Class argumentType = (Class)this.argumentType(type);
            List<String> values = ParameterConverters.trim(Arrays.asList(value.split(this.valueSeparator)));
            ArrayList<Number> numbers = new ArrayList<Number>();
            for (String numberValue : values) {
                numbers.add((Number)this.numberConverter.convertValue(numberValue, argumentType));
            }
            return numbers;
        }
    }

    public static class NumberConverter
    implements ParameterConverter {
        private static List<Class<?>> primitiveTypes = Arrays.asList(Byte.TYPE, Short.TYPE, Integer.TYPE, Float.TYPE, Long.TYPE, Double.TYPE);
        private final NumberFormat numberFormat;

        public NumberConverter() {
            this(NumberFormat.getInstance(DEFAULT_NUMBER_FORMAT_LOCAL));
        }

        public NumberConverter(NumberFormat numberFormat) {
            this.numberFormat = numberFormat;
        }

        public boolean accept(Type type) {
            if (type instanceof Class) {
                return Number.class.isAssignableFrom((Class)type) || primitiveTypes.contains(type);
            }
            return false;
        }

        public Object convertValue(String value, Type type) {
            try {
                Number n = this.numberFormat.parse(value);
                if (type == Byte.class || type == Byte.TYPE) {
                    return n.byteValue();
                }
                if (type == Short.class || type == Short.TYPE) {
                    return n.shortValue();
                }
                if (type == Integer.class || type == Integer.TYPE) {
                    return n.intValue();
                }
                if (type == Float.class || type == Float.TYPE) {
                    return Float.valueOf(n.floatValue());
                }
                if (type == Long.class || type == Long.TYPE) {
                    return n.longValue();
                }
                if (type == Double.class || type == Double.TYPE) {
                    return n.doubleValue();
                }
                if (type == BigInteger.class) {
                    return BigInteger.valueOf(n.longValue());
                }
                if (type == BigDecimal.class) {
                    return new BigDecimal(this.canonicalize(value));
                }
                return n;
            }
            catch (ParseException e) {
                throw new ParameterConvertionFailed(value, e);
            }
        }

        private String canonicalize(String value) {
            char decimalPointSeparator = this.numberFormat.format(1.01).charAt(1);
            int decimalPointPosition = value.lastIndexOf(decimalPointSeparator);
            value = value.trim();
            if (decimalPointPosition != -1) {
                String sf = value.substring(0, decimalPointPosition).replace("[^0-9]", "");
                String dp = value.substring(decimalPointPosition + 1);
                return sf + "." + dp;
            }
            return value.replace(' ', ',');
        }
    }

    public static class ParameterConvertionFailed
    extends RuntimeException {
        public ParameterConvertionFailed(String message) {
            super(message);
        }

        public ParameterConvertionFailed(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static interface ParameterConverter {
        public boolean accept(Type var1);

        public Object convertValue(String var1, Type var2);
    }
}

