/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.text.MessageFormat;
import java.util.Arrays;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.jbehave.core.annotations.Pending;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.steps.StepCreator;
import org.jbehave.core.steps.StepType;

public class PendingStepMethodGenerator {
    private static final String METHOD_SOURCE = "@{0}(\"{1}\")\n@{2}\npublic void {3}()'{'\n  // {4}\n'}'\n";
    private final Keywords keywords;

    public PendingStepMethodGenerator(Keywords keywords) {
        this.keywords = keywords;
    }

    public String generateMethod(StepCreator.PendingStep step) {
        String stepAsString = step.stepAsString();
        String previousNonAndStepAsString = step.previousNonAndStepAsString();
        StepType stepType = null;
        stepType = this.keywords.isAndStep(stepAsString) ? this.keywords.stepTypeFor(previousNonAndStepAsString) : this.keywords.stepTypeFor(stepAsString);
        String stepPattern = this.keywords.stepWithoutStartingWord(stepAsString, stepType);
        String stepAnnotation = StringUtils.capitalize((String)stepType.name().toLowerCase());
        String methodName = this.methodName(stepType, stepPattern);
        String pendingAnnotation = Pending.class.getSimpleName();
        return MessageFormat.format(METHOD_SOURCE, stepAnnotation, StringEscapeUtils.escapeJava((String)stepPattern), pendingAnnotation, methodName, this.keywords.pending());
    }

    private String methodName(StepType stepType, String stepPattern) {
        String name = stepType.name().toLowerCase() + WordUtils.capitalize((String)stepPattern);
        for (String remove : Arrays.asList(" ", "'", "\"", "\\.", "\\,", "\\;", "\\:", "\\!", "\\|", "<", ">", "\\*")) {
            name = name.replaceAll(remove, "");
        }
        return name;
    }
}

