/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.annotations.AfterStories;
import org.jbehave.core.annotations.AfterStory;
import org.jbehave.core.annotations.Alias;
import org.jbehave.core.annotations.Aliases;
import org.jbehave.core.annotations.BeforeScenario;
import org.jbehave.core.annotations.BeforeStories;
import org.jbehave.core.annotations.BeforeStory;
import org.jbehave.core.annotations.Composite;
import org.jbehave.core.annotations.Given;
import org.jbehave.core.annotations.Then;
import org.jbehave.core.annotations.When;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.MostUsefulConfiguration;
import org.jbehave.core.steps.BeforeOrAfterStep;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.StepCandidate;
import org.jbehave.core.steps.StepCollector;
import org.jbehave.core.steps.StepType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Steps
implements CandidateSteps {
    private final Configuration configuration;
    private final Object instance;

    public Steps() {
        this(new MostUsefulConfiguration());
    }

    public Steps(Configuration configuration) {
        this(configuration, null);
    }

    public Steps(Configuration configuration, Object instance) {
        this.configuration = configuration;
        this.instance = instance;
    }

    public Object instance() {
        if (this.instance == null) {
            return this;
        }
        return this.instance;
    }

    @Override
    public Configuration configuration() {
        return this.configuration;
    }

    @Override
    public List<StepCandidate> listCandidates() {
        ArrayList<StepCandidate> candidates = new ArrayList<StepCandidate>();
        for (Method method : this.allMethods()) {
            int priority;
            String value;
            Annotation annotation;
            if (method.isAnnotationPresent(Given.class)) {
                annotation = method.getAnnotation(Given.class);
                value = annotation.value();
                priority = annotation.priority();
                this.addCandidate(candidates, method, StepType.GIVEN, value, priority);
                this.addCandidatesFromAliases(candidates, method, StepType.GIVEN, priority);
            }
            if (method.isAnnotationPresent(When.class)) {
                annotation = method.getAnnotation(When.class);
                value = annotation.value();
                priority = annotation.priority();
                this.addCandidate(candidates, method, StepType.WHEN, value, priority);
                this.addCandidatesFromAliases(candidates, method, StepType.WHEN, priority);
            }
            if (!method.isAnnotationPresent(Then.class)) continue;
            annotation = method.getAnnotation(Then.class);
            value = annotation.value();
            priority = annotation.priority();
            this.addCandidate(candidates, method, StepType.THEN, value, priority);
            this.addCandidatesFromAliases(candidates, method, StepType.THEN, priority);
        }
        return candidates;
    }

    private void addCandidate(List<StepCandidate> candidates, Method method, StepType stepType, String stepPatternAsString, int priority) {
        this.checkForDuplicateCandidates(candidates, stepType, stepPatternAsString);
        StepCandidate candidate = this.createCandidate(method, stepType, stepPatternAsString, priority, this.configuration);
        candidate.useStepMonitor(this.configuration.stepMonitor());
        candidate.useParanamer(this.configuration.paranamer());
        candidate.doDryRun(this.configuration.storyControls().dryRun());
        if (method.isAnnotationPresent(Composite.class)) {
            candidate.composedOf(method.getAnnotation(Composite.class).steps());
        }
        candidates.add(candidate);
    }

    private void checkForDuplicateCandidates(List<StepCandidate> candidates, StepType stepType, String patternAsString) {
        for (StepCandidate candidate : candidates) {
            if (candidate.getStepType() != stepType || !candidate.getPatternAsString().equals(patternAsString)) continue;
            throw new DuplicateCandidateFound(stepType, patternAsString);
        }
    }

    private void addCandidatesFromAliases(List<StepCandidate> candidates, Method method, StepType stepType, int priority) {
        if (method.isAnnotationPresent(Aliases.class)) {
            String[] aliases;
            for (String alias : aliases = method.getAnnotation(Aliases.class).values()) {
                this.addCandidate(candidates, method, stepType, alias, priority);
            }
        }
        if (method.isAnnotationPresent(Alias.class)) {
            String alias = method.getAnnotation(Alias.class).value();
            this.addCandidate(candidates, method, stepType, alias, priority);
        }
    }

    private StepCandidate createCandidate(Method method, StepType stepType, String stepPatternAsString, int priority, Configuration configuration) {
        return new StepCandidate(stepPatternAsString, priority, stepType, method, this.instance(), configuration.keywords(), configuration.stepPatternParser(), configuration.parameterConverters());
    }

    @Override
    public List<BeforeOrAfterStep> listBeforeOrAfterStories() {
        ArrayList<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        steps.addAll(this.stepsHaving(StepCollector.Stage.BEFORE, BeforeStories.class));
        steps.addAll(this.stepsHaving(StepCollector.Stage.AFTER, AfterStories.class));
        return steps;
    }

    @Override
    public List<BeforeOrAfterStep> listBeforeOrAfterStory(boolean givenStory) {
        ArrayList<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        steps.addAll(this.stepsHaving(StepCollector.Stage.BEFORE, BeforeStory.class, givenStory));
        steps.addAll(this.stepsHaving(StepCollector.Stage.AFTER, AfterStory.class, givenStory));
        return steps;
    }

    @Override
    public List<BeforeOrAfterStep> listBeforeOrAfterScenario() {
        ArrayList<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        steps.addAll(this.stepsHaving(StepCollector.Stage.BEFORE, BeforeScenario.class));
        steps.addAll(this.stepsHaving(StepCollector.Stage.AFTER, AfterScenario.class, AfterScenario.Outcome.ANY, AfterScenario.Outcome.SUCCESS, AfterScenario.Outcome.FAILURE));
        return steps;
    }

    private List<BeforeOrAfterStep> stepsHaving(StepCollector.Stage stage, Class<? extends Annotation> annotationClass, boolean givenStory) {
        ArrayList<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        for (Method method : this.annotatatedMethods(annotationClass)) {
            if (!this.runnableStoryStep(method.getAnnotation(annotationClass), givenStory)) continue;
            steps.add(this.createBeforeOrAfterStep(stage, method));
        }
        return steps;
    }

    private boolean runnableStoryStep(Annotation annotation, boolean givenStory) {
        boolean uponGivenStory = this.uponGivenStory(annotation);
        return uponGivenStory == givenStory;
    }

    private boolean uponGivenStory(Annotation annotation) {
        if (annotation instanceof BeforeStory) {
            return ((BeforeStory)annotation).uponGivenStory();
        }
        if (annotation instanceof AfterStory) {
            return ((AfterStory)annotation).uponGivenStory();
        }
        return false;
    }

    private List<BeforeOrAfterStep> stepsHaving(StepCollector.Stage stage, Class<? extends Annotation> annotationClass) {
        ArrayList<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        for (Method method : this.annotatatedMethods(annotationClass)) {
            steps.add(this.createBeforeOrAfterStep(stage, method));
        }
        return steps;
    }

    private List<BeforeOrAfterStep> stepsHaving(StepCollector.Stage stage, Class<? extends AfterScenario> annotationClass, AfterScenario.Outcome ... outcomes) {
        ArrayList<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        for (Method method : this.annotatatedMethods(annotationClass)) {
            AfterScenario annotation = method.getAnnotation(annotationClass);
            for (AfterScenario.Outcome outcome : outcomes) {
                if (!outcome.equals((Object)annotation.uponOutcome())) continue;
                steps.add(this.createBeforeOrAfterStep(stage, method, outcome));
            }
        }
        return steps;
    }

    private BeforeOrAfterStep createBeforeOrAfterStep(StepCollector.Stage stage, Method method) {
        return new BeforeOrAfterStep(stage, method, this.instance());
    }

    private BeforeOrAfterStep createBeforeOrAfterStep(StepCollector.Stage stage, Method method, AfterScenario.Outcome outcome) {
        return new BeforeOrAfterStep(stage, method, this.instance(), outcome);
    }

    private List<Method> allMethods() {
        return Arrays.asList(this.instance().getClass().getMethods());
    }

    private List<Method> annotatatedMethods(Class<? extends Annotation> annotationClass) {
        ArrayList<Method> annotated = new ArrayList<Method>();
        for (Method method : this.allMethods()) {
            if (!method.isAnnotationPresent(annotationClass)) continue;
            annotated.add(method);
        }
        return annotated;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append(this.instance()).toString();
    }

    public static class DuplicateCandidateFound
    extends RuntimeException {
        public DuplicateCandidateFound(StepType stepType, String patternAsString) {
            super((Object)((Object)stepType) + " " + patternAsString);
        }
    }
}

