/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.osgi;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.osgi.StartLevelAware;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.jboss.arquillian.testenricher.osgi.BundleAssociation;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;
import org.osgi.framework.startlevel.BundleStartLevel;

public class OSGiTestEnricher
implements TestEnricher {
    private static final Logger log = Logger.getLogger(OSGiTestEnricher.class.getName());

    public void enrich(Object testCase) {
        Class<?> testClass = testCase.getClass();
        for (Method method : testClass.getDeclaredMethods()) {
            Deployment andep;
            if (!method.isAnnotationPresent(Deployment.class) || !(andep = method.getAnnotation(Deployment.class)).managed() || !andep.testable() || !method.isAnnotationPresent(StartLevelAware.class)) continue;
            StartLevelAware startLevelAware = method.getAnnotation(StartLevelAware.class);
            Bundle bundle = this.getBundle(testCase);
            if (bundle == null) continue;
            int bundleStartLevel = startLevelAware.startLevel();
            log.fine("Setting bundle start level of " + bundle + " to: " + bundleStartLevel);
            BundleStartLevel startLevel = (BundleStartLevel)bundle.adapt(BundleStartLevel.class);
            startLevel.setStartLevel(bundleStartLevel);
            if (!startLevelAware.autostart()) continue;
            try {
                bundle.start();
            }
            catch (BundleException ex) {
                log.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    public Object[] resolve(Method method) {
        return null;
    }

    private Bundle getBundle(Object testCase) {
        ClassLoader classLoader;
        Bundle bundle = BundleAssociation.getBundle();
        if (bundle == null && (classLoader = testCase.getClass().getClassLoader()) instanceof BundleReference) {
            BundleReference bref = (BundleReference)classLoader;
            bundle = bref.getBundle();
        }
        return bundle;
    }
}

