/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import java.util.ArrayList;

public class ThreadLocalStack<T> {
    private ThreadLocal<ArrayList<T>> local = new ThreadLocal();

    public void push(T obj) {
        this.getStack(true).add(obj);
    }

    private ArrayList<T> getStack(boolean create) {
        ArrayList<Object> stack = this.local.get();
        if (stack == null && create) {
            stack = new ArrayList();
            this.local.set(stack);
        }
        return stack;
    }

    public T get() {
        ArrayList<T> stack = this.local.get();
        if (stack == null || stack.isEmpty()) {
            return null;
        }
        return stack.get(stack.size() - 1);
    }

    public T pop() {
        ArrayList<T> stack = this.local.get();
        if (stack == null || stack.isEmpty()) {
            return null;
        }
        return stack.remove(stack.size() - 1);
    }

    public void setLast(T obj) {
        ArrayList<T> stack = this.getStack(true);
        if (stack.isEmpty()) {
            stack.add(obj);
        } else {
            stack.set(stack.size() - 1, obj);
        }
    }

    public boolean isEmpty() {
        ArrayList<T> stack = this.getStack(false);
        return stack == null || stack.isEmpty();
    }

    public int size() {
        ArrayList<T> stack = this.getStack(false);
        return stack == null ? 0 : stack.size();
    }

    public void clear() {
        this.local.set(null);
    }

    public T get(int i) {
        ArrayList<T> stack = this.getStack(false);
        if (stack == null) {
            return null;
        }
        if (i < 0 || i > this.size()) {
            return null;
        }
        return stack.get(i);
    }
}

