/*
 * Decompiled with CFR 0.152.
 */
package jodd.csselly.selector;

import java.util.List;
import jodd.csselly.CSSelly;
import jodd.csselly.CssSelector;
import jodd.csselly.selector.PseudoFunction;
import jodd.csselly.selector.PseudoFunctionExpression;
import jodd.lagarto.dom.Element;
import jodd.lagarto.dom.Node;
import jodd.lagarto.dom.NodeMatcher;
import jodd.lagarto.dom.NodeSelector;
import jodd.util.StringUtil;

public interface PseudoFunctions {

    public static class NOT
    extends PseudoFunction<List<List<CssSelector>>> {
        @Override
        public List<List<CssSelector>> parseExpression(String expression) {
            if (StringUtil.startsWithChar((String)expression, (char)'\'') || StringUtil.startsWithChar((String)expression, (char)'\"')) {
                expression = expression.substring(1, expression.length() - 1);
            }
            return CSSelly.parse(expression);
        }

        @Override
        public boolean match(Node node, List<List<CssSelector>> selectors) {
            return !new NodeMatcher(node).match(selectors);
        }
    }

    public static class HAS
    extends PseudoFunction<List<List<CssSelector>>> {
        @Override
        public List<List<CssSelector>> parseExpression(String expression) {
            if (StringUtil.startsWithChar((String)expression, (char)'\'') || StringUtil.startsWithChar((String)expression, (char)'\"')) {
                expression = expression.substring(1, expression.length() - 1);
            }
            return CSSelly.parse(expression);
        }

        @Override
        public boolean match(Node node, List<List<CssSelector>> selectors) {
            List<Node> matchedNodes = new NodeSelector(node).select(selectors);
            return !matchedNodes.isEmpty();
        }
    }

    public static class CONTAINS
    extends PseudoFunction<String> {
        @Override
        public String parseExpression(String expression) {
            if (StringUtil.startsWithChar((String)expression, (char)'\'') || StringUtil.startsWithChar((String)expression, (char)'\"')) {
                expression = expression.substring(1, expression.length() - 1);
            }
            return expression;
        }

        @Override
        public boolean match(Node node, String expression) {
            String text = node.getTextContent();
            return text.contains(expression);
        }
    }

    public static class LT
    extends PseudoFunction<Integer> {
        @Override
        public Integer parseExpression(String expression) {
            return Integer.valueOf(expression.trim());
        }

        @Override
        public boolean match(Node node, Integer expression) {
            return true;
        }

        @Override
        public boolean matchInRange(List<Node> matchedResults, Node node, int index, Integer expression) {
            int value = expression;
            return index < value;
        }
    }

    public static class GT
    extends PseudoFunction<Integer> {
        @Override
        public Integer parseExpression(String expression) {
            return Integer.valueOf(expression.trim());
        }

        @Override
        public boolean match(Node node, Integer expression) {
            return true;
        }

        @Override
        public boolean matchInRange(List<Node> matchedResults, Node node, int index, Integer expression) {
            int value = expression;
            return index > value;
        }
    }

    public static class EQ
    extends PseudoFunction<Integer> {
        @Override
        public Integer parseExpression(String expression) {
            return Integer.valueOf(expression.trim());
        }

        @Override
        public boolean match(Node node, Integer expression) {
            return true;
        }

        @Override
        public boolean matchInRange(List<Node> matchedResults, Node node, int index, Integer expression) {
            int value = expression;
            if (value >= 0) {
                return index == value;
            }
            return index == matchedResults.size() + value;
        }
    }

    public static class NTH_LAST_OF_TYPE
    extends PseudoFunction<PseudoFunctionExpression> {
        @Override
        public PseudoFunctionExpression parseExpression(String expression) {
            return new PseudoFunctionExpression(expression);
        }

        @Override
        public boolean match(Node node, PseudoFunctionExpression expression) {
            Element child = node.getParentNode().getLastChildElement(node.getNodeName());
            int value = child.getSiblingNameIndex() + 1 - node.getSiblingNameIndex();
            return expression.match(value);
        }
    }

    public static class NTH_OF_TYPE
    extends PseudoFunction<PseudoFunctionExpression> {
        @Override
        public PseudoFunctionExpression parseExpression(String expression) {
            return new PseudoFunctionExpression(expression);
        }

        @Override
        public boolean match(Node node, PseudoFunctionExpression expression) {
            int value = node.getSiblingNameIndex() + 1;
            return expression.match(value);
        }
    }

    public static class NTH_LAST_CHILD
    extends PseudoFunction<PseudoFunctionExpression> {
        @Override
        public PseudoFunctionExpression parseExpression(String expression) {
            return new PseudoFunctionExpression(expression);
        }

        @Override
        public boolean match(Node node, PseudoFunctionExpression expression) {
            int value = node.getParentNode().getChildElementsCount() - node.getSiblingElementIndex();
            return expression.match(value);
        }
    }

    public static class NTH_CHILD
    extends PseudoFunction<PseudoFunctionExpression> {
        @Override
        public PseudoFunctionExpression parseExpression(String expression) {
            return new PseudoFunctionExpression(expression);
        }

        @Override
        public boolean match(Node node, PseudoFunctionExpression expression) {
            int value = node.getSiblingElementIndex() + 1;
            return expression.match(value);
        }
    }
}

