/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import jodd.util.ClassLoaderUtil;
import jodd.util.StringUtil;
import jodd.util.SystemUtil;

public final class SystemInfo {
    private static HostInfoLazy hostInfoLazy;
    private final String JAVA_VM_NAME = SystemUtil.get("java.vm.name");
    private final String JAVA_VM_VERSION = SystemUtil.get("java.vm.version");
    private final String JAVA_VM_VENDOR = SystemUtil.get("java.vm.vendor");
    private final String JAVA_VM_INFO = SystemUtil.get("java.vm.info");
    private final String JAVA_VM_SPECIFICATION_NAME = SystemUtil.get("java.vm.specification.name");
    private final String JAVA_VM_SPECIFICATION_VERSION = SystemUtil.get("java.vm.specification.version");
    private final String JAVA_VM_SPECIFICATION_VENDOR = SystemUtil.get("java.vm.specification.vendor");
    private final String JAVA_VERSION = SystemUtil.get("java.version");
    private final int JAVA_VERSION_NUMBER = this.detectJavaVersionNumber();
    private final String JAVA_VENDOR = SystemUtil.get("java.vendor");
    private final String JAVA_VENDOR_URL = SystemUtil.get("java.vendor.url");
    private final String JAVA_SPECIFICATION_VERSION = SystemUtil.get("java.specification.version");
    private final String JAVA_SPECIFICATION_NAME = SystemUtil.get("java.specification.name");
    private final String JAVA_SPECIFICATION_VENDOR = SystemUtil.get("java.specification.vendor");
    private final String[] JRE_PACKAGES = this.buildJrePackages(this.JAVA_VERSION_NUMBER);
    private final String OS_VERSION = SystemUtil.get("os.version");
    private final String OS_ARCH = SystemUtil.get("os.arch");
    private final String OS_NAME = SystemUtil.get("os.name");
    private final boolean IS_ANDROID = SystemInfo.isAndroid0();
    private final boolean IS_OS_AIX = this.matchOS("AIX");
    private final boolean IS_OS_HP_UX = this.matchOS("HP-UX");
    private final boolean IS_OS_IRIX = this.matchOS("Irix");
    private final boolean IS_OS_LINUX = this.matchOS("Linux") || this.matchOS("LINUX");
    private final boolean IS_OS_MAC = this.matchOS("Mac");
    private final boolean IS_OS_MAC_OSX = this.matchOS("Mac OS X");
    private final boolean IS_OS_OS2 = this.matchOS("OS/2");
    private final boolean IS_OS_SOLARIS = this.matchOS("Solaris");
    private final boolean IS_OS_SUN_OS = this.matchOS("SunOS");
    private final boolean IS_OS_WINDOWS = this.matchOS("Windows");
    private final boolean IS_OS_WINDOWS_2000 = this.matchOS("Windows", "5.0");
    private final boolean IS_OS_WINDOWS_95 = this.matchOS("Windows 9", "4.0");
    private final boolean IS_OS_WINDOWS_98 = this.matchOS("Windows 9", "4.1");
    private final boolean IS_OS_WINDOWS_ME = this.matchOS("Windows", "4.9");
    private final boolean IS_OS_WINDOWS_NT = this.matchOS("Windows NT");
    private final boolean IS_OS_WINDOWS_XP = this.matchOS("Windows", "5.1");
    private final String FILE_SEPARATOR = SystemUtil.get("file.separator");
    private final String LINE_SEPARATOR = SystemUtil.get("line.separator");
    private final String PATH_SEPARATOR = SystemUtil.get("path.separator");
    private final String FILE_ENCODING = SystemUtil.get("file.encoding");
    private final Runtime runtime = Runtime.getRuntime();
    private final String USER_NAME = SystemUtil.get("user.name");
    private final String USER_HOME = this.nosep(SystemUtil.get("user.home"));
    private final String USER_DIR = this.nosep(SystemUtil.get("user.dir"));
    private final String USER_LANGUAGE = SystemUtil.get("user.language");
    private final String USER_COUNTRY = SystemUtil.get("user.country") == null ? SystemUtil.get("user.region") : SystemUtil.get("user.country");
    private final String JAVA_IO_TMPDIR = SystemUtil.get("java.io.tmpdir");
    private final String JAVA_HOME = this.nosep(SystemUtil.get("java.home"));
    private final String[] SYSTEM_CLASS_PATH = StringUtil.splitc(SystemUtil.get("java.class.path"), File.pathSeparator);

    public final String getHostName() {
        if (hostInfoLazy == null) {
            hostInfoLazy = new HostInfoLazy();
        }
        return hostInfoLazy.HOST_NAME;
    }

    public final String getHostAddress() {
        if (hostInfoLazy == null) {
            hostInfoLazy = new HostInfoLazy();
        }
        return hostInfoLazy.HOST_ADDRESS;
    }

    public final String getJvmName() {
        return this.JAVA_VM_NAME;
    }

    public final String getJvmVersion() {
        return this.JAVA_VM_VERSION;
    }

    public final String getJvmVendor() {
        return this.JAVA_VM_VENDOR;
    }

    public final String getJvmInfo() {
        return this.JAVA_VM_INFO;
    }

    public final String getJvmSpecificationName() {
        return this.JAVA_VM_SPECIFICATION_NAME;
    }

    public final String getJvmSpecificationVersion() {
        return this.JAVA_VM_SPECIFICATION_VERSION;
    }

    public final String getJvmSpecificationVendor() {
        return this.JAVA_VM_SPECIFICATION_VENDOR;
    }

    public String getJavaVersion() {
        return this.JAVA_VERSION;
    }

    public int getJavaVersionNumber() {
        return this.JAVA_VERSION_NUMBER;
    }

    public String getJavaVendor() {
        return this.JAVA_VENDOR;
    }

    public String getJavaVendorURL() {
        return this.JAVA_VENDOR_URL;
    }

    public String getJavaSpecificationVersion() {
        return this.JAVA_SPECIFICATION_VERSION;
    }

    public final String getJavaSpecificationName() {
        return this.JAVA_SPECIFICATION_NAME;
    }

    public final String getJavaSpecificationVendor() {
        return this.JAVA_SPECIFICATION_VENDOR;
    }

    public String[] getJrePackages() {
        return this.JRE_PACKAGES;
    }

    private String[] buildJrePackages(int javaVersionNumber) {
        ArrayList<String> packages = new ArrayList<String>();
        switch (javaVersionNumber) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                packages.add("com.sun.org.apache");
            }
            case 4: {
                if (javaVersionNumber == 4) {
                    packages.add("org.apache.crimson");
                    packages.add("org.apache.xalan");
                    packages.add("org.apache.xml");
                    packages.add("org.apache.xpath");
                }
                packages.add("org.ietf.jgss");
                packages.add("org.w3c.dom");
                packages.add("org.xml.sax");
            }
            case 3: {
                packages.add("org.omg");
                packages.add("com.sun.corba");
                packages.add("com.sun.jndi");
                packages.add("com.sun.media");
                packages.add("com.sun.naming");
                packages.add("com.sun.org.omg");
                packages.add("com.sun.rmi");
                packages.add("sunw.io");
                packages.add("sunw.util");
            }
            case 2: {
                packages.add("com.sun.java");
                packages.add("com.sun.image");
            }
        }
        packages.add("sun");
        packages.add("java");
        packages.add("javax");
        return packages.toArray(new String[0]);
    }

    private int detectJavaVersionNumber() {
        String javaVersion = this.JAVA_VERSION;
        int lastDashNdx = javaVersion.lastIndexOf(45);
        if (lastDashNdx != -1) {
            javaVersion = javaVersion.substring(0, lastDashNdx);
        }
        if (javaVersion.startsWith("1.")) {
            int index = javaVersion.indexOf(46, 2);
            return Integer.parseInt(javaVersion.substring(2, index));
        }
        int index = javaVersion.indexOf(46);
        return Integer.parseInt(index == -1 ? javaVersion : javaVersion.substring(0, index));
    }

    public boolean isAtLeastJavaVersion(int version) {
        return this.JAVA_VERSION_NUMBER >= version;
    }

    public boolean isJavaVersion(int version) {
        return this.JAVA_VERSION_NUMBER == version;
    }

    public final String getOsArchitecture() {
        return this.OS_ARCH;
    }

    public final String getOsName() {
        return this.OS_NAME;
    }

    public final String getOsVersion() {
        return this.OS_VERSION;
    }

    public boolean isAndroid() {
        return this.IS_ANDROID;
    }

    private static boolean isAndroid0() {
        try {
            Class.forName("android.app.Application", false, ClassLoaderUtil.getSystemClassLoader());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public final boolean isAix() {
        return this.IS_OS_AIX;
    }

    public final boolean isHpUx() {
        return this.IS_OS_HP_UX;
    }

    public final boolean isIrix() {
        return this.IS_OS_IRIX;
    }

    public final boolean isLinux() {
        return this.IS_OS_LINUX;
    }

    public final boolean isMac() {
        return this.IS_OS_MAC;
    }

    public final boolean isMacOsX() {
        return this.IS_OS_MAC_OSX;
    }

    public final boolean isOs2() {
        return this.IS_OS_OS2;
    }

    public final boolean isSolaris() {
        return this.IS_OS_SOLARIS;
    }

    public final boolean isSunOS() {
        return this.IS_OS_SUN_OS;
    }

    public final boolean isWindows() {
        return this.IS_OS_WINDOWS;
    }

    public final boolean isWindows2000() {
        return this.IS_OS_WINDOWS_2000;
    }

    public final boolean isWindows95() {
        return this.IS_OS_WINDOWS_95;
    }

    public final boolean isWindows98() {
        return this.IS_OS_WINDOWS_98;
    }

    public final boolean isWindowsME() {
        return this.IS_OS_WINDOWS_ME;
    }

    public final boolean isWindowsNT() {
        return this.IS_OS_WINDOWS_NT;
    }

    public final boolean isWindowsXP() {
        return this.IS_OS_WINDOWS_XP;
    }

    public final String getFileSeparator() {
        return this.FILE_SEPARATOR;
    }

    public final String getLineSeparator() {
        return this.LINE_SEPARATOR;
    }

    public final String getPathSeparator() {
        return this.PATH_SEPARATOR;
    }

    public final String getFileEncoding() {
        return this.FILE_ENCODING;
    }

    private boolean matchOS(String osNamePrefix) {
        if (this.OS_NAME == null) {
            return false;
        }
        return this.OS_NAME.startsWith(osNamePrefix);
    }

    private boolean matchOS(String osNamePrefix, String osVersionPrefix) {
        if (this.OS_NAME == null || this.OS_VERSION == null) {
            return false;
        }
        return this.OS_NAME.startsWith(osNamePrefix) && this.OS_VERSION.startsWith(osVersionPrefix);
    }

    public final long getMaxMemory() {
        return this.runtime.maxMemory();
    }

    public final long getTotalMemory() {
        return this.runtime.totalMemory();
    }

    public final long getFreeMemory() {
        return this.runtime.freeMemory();
    }

    public final long getAvailableMemory() {
        return this.runtime.maxMemory() - this.runtime.totalMemory() + this.runtime.freeMemory();
    }

    public final long getUsedMemory() {
        return this.runtime.totalMemory() - this.runtime.freeMemory();
    }

    public final long getCurrentPID() {
        return Long.parseLong(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
    }

    public final long getCPUs() {
        return this.runtime.availableProcessors();
    }

    public final String getUserName() {
        return this.USER_NAME;
    }

    public final String getHomeDir() {
        return this.USER_HOME;
    }

    public final String getWorkingDir() {
        return this.USER_DIR;
    }

    public final String getTempDir() {
        return this.JAVA_IO_TMPDIR;
    }

    public final String getUserLanguage() {
        return this.USER_LANGUAGE;
    }

    public final String getUserCountry() {
        return this.USER_COUNTRY;
    }

    public String getJavaHomeDir() {
        return this.JAVA_HOME;
    }

    public String[] getSystemClasspath() {
        return this.SYSTEM_CLASS_PATH;
    }

    protected String nosep(String in) {
        if (in.endsWith(File.separator)) {
            return in.substring(0, in.length() - 1);
        }
        return in;
    }

    private static class HostInfoLazy {
        private final String HOST_NAME;
        private final String HOST_ADDRESS;

        public HostInfoLazy() {
            String hostAddress;
            String hostName;
            try {
                InetAddress localhost = InetAddress.getLocalHost();
                hostName = localhost.getHostName();
                hostAddress = localhost.getHostAddress();
            }
            catch (UnknownHostException uhex) {
                hostName = "localhost";
                hostAddress = "127.0.0.1";
            }
            this.HOST_NAME = hostName;
            this.HOST_ADDRESS = hostAddress;
        }
    }
}

