/*
 * Decompiled with CFR 0.152.
 */
package jodd.introspector;

import java.lang.reflect.Constructor;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.CtorDescriptor;

public class Ctors {
    protected final ClassDescriptor classDescriptor;
    protected final CtorDescriptor[] allCtors;
    protected CtorDescriptor defaultCtor;

    public Ctors(ClassDescriptor classDescriptor) {
        this.classDescriptor = classDescriptor;
        this.allCtors = this.inspectConstructors();
    }

    protected CtorDescriptor[] inspectConstructors() {
        Class type = this.classDescriptor.getType();
        Constructor<?>[] ctors = type.getDeclaredConstructors();
        CtorDescriptor[] allCtors = new CtorDescriptor[ctors.length];
        for (int i = 0; i < ctors.length; ++i) {
            CtorDescriptor ctorDescriptor;
            Constructor<?> ctor = ctors[i];
            allCtors[i] = ctorDescriptor = this.createCtorDescriptor(ctor);
            if (!ctorDescriptor.isDefault()) continue;
            this.defaultCtor = ctorDescriptor;
        }
        return allCtors;
    }

    protected CtorDescriptor createCtorDescriptor(Constructor ctor) {
        return new CtorDescriptor(this.classDescriptor, ctor);
    }

    public CtorDescriptor getDefaultCtor() {
        return this.defaultCtor;
    }

    public CtorDescriptor getCtorDescriptor(Class ... args) {
        block0: for (CtorDescriptor ctorDescriptor : this.allCtors) {
            Class[] arg = ctorDescriptor.getParameters();
            if (arg.length != args.length) continue;
            for (int j = 0; j < arg.length; ++j) {
                if (arg[j] != args[j]) continue block0;
            }
            return ctorDescriptor;
        }
        return null;
    }

    CtorDescriptor[] getAllCtorDescriptors() {
        return this.allCtors;
    }
}

