/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import jodd.util.ArraysUtil;

public class Util {
    public static String toString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static int length(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size();
        }
        if (obj instanceof Map) {
            return ((Map)obj).size();
        }
        if (obj instanceof Iterator) {
            Iterator iter = (Iterator)obj;
            int count = 0;
            while (iter.hasNext()) {
                ++count;
                iter.next();
            }
            return count;
        }
        if (obj instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)obj;
            int count = 0;
            while (enumeration.hasMoreElements()) {
                ++count;
                enumeration.nextElement();
            }
            return count;
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj);
        }
        return -1;
    }

    public static boolean containsElement(Object obj, Object element) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            if (element == null) {
                return false;
            }
            return ((String)obj).contains(element.toString());
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).contains(element);
        }
        if (obj instanceof Map) {
            return ((Map)obj).values().contains(element);
        }
        if (obj instanceof Iterator) {
            Iterator iter = (Iterator)obj;
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!Objects.equals(o, element)) continue;
                return true;
            }
            return false;
        }
        if (obj instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)obj;
            while (enumeration.hasMoreElements()) {
                Object o = enumeration.nextElement();
                if (!Objects.equals(o, element)) continue;
                return true;
            }
            return false;
        }
        if (obj.getClass().isArray()) {
            int len = Array.getLength(obj);
            for (int i = 0; i < len; ++i) {
                Object o = Array.get(obj, i);
                if (!Objects.equals(o, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static String toPrettyString(Object value) {
        if (value == null) {
            return "null";
        }
        Class<?> type = value.getClass();
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            if (componentType.isPrimitive()) {
                StringBuilder sb = new StringBuilder();
                sb.append('[');
                if (componentType == Integer.TYPE) {
                    sb.append(ArraysUtil.toString((int[])value));
                } else if (componentType == Long.TYPE) {
                    sb.append(ArraysUtil.toString((long[])value));
                } else if (componentType == Double.TYPE) {
                    sb.append(ArraysUtil.toString((double[])value));
                } else if (componentType == Float.TYPE) {
                    sb.append(ArraysUtil.toString((float[])value));
                } else if (componentType == Boolean.TYPE) {
                    sb.append(ArraysUtil.toString((boolean[])value));
                } else if (componentType == Short.TYPE) {
                    sb.append(ArraysUtil.toString((short[])value));
                } else if (componentType == Byte.TYPE) {
                    sb.append(ArraysUtil.toString((byte[])value));
                } else {
                    throw new IllegalArgumentException();
                }
                sb.append(']');
                return sb.toString();
            }
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            Object[] array = (Object[])value;
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(Util.toPrettyString(array[i]));
            }
            sb.append(']');
            return sb.toString();
        }
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            int i = 0;
            for (Object o : iterable) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(Util.toPrettyString(o));
                ++i;
            }
            sb.append('}');
            return sb.toString();
        }
        return value.toString();
    }
}

