/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt;

import com.jogamp.newt.util.EDTUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeWindowException;
import jogamp.newt.Debug;

public abstract class Display {
    public static final boolean DEBUG = Debug.debug("Display");
    protected static ArrayList<Display> displayList = new ArrayList();
    protected static int displaysActive = 0;

    public abstract int hashCode();

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Display) {
            Display display = (Display)object;
            return display.getFQName().equals(this.getFQName());
        }
        return false;
    }

    public abstract void createNative() throws NativeWindowException;

    public abstract void destroy();

    public abstract boolean validateEDT();

    public abstract boolean isNativeValid();

    public abstract int getReferenceCount();

    public abstract int addReference() throws NativeWindowException;

    public abstract int removeReference();

    public abstract AbstractGraphicsDevice getGraphicsDevice();

    public abstract long getHandle();

    public abstract String getFQName();

    public abstract int getId();

    public abstract String getName();

    public abstract String getType();

    public abstract boolean isExclusive();

    public abstract EDTUtil setEDTUtil(EDTUtil var1);

    public abstract EDTUtil getEDTUtil();

    public abstract boolean isEDTRunning();

    public abstract void dispatchMessages();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpDisplayList(String string) {
        ArrayList<Display> arrayList = displayList;
        synchronized (arrayList) {
            Iterator<Display> iterator = displayList.iterator();
            System.err.println(string + " DisplayList[] entries: " + displayList.size() + " - " + Display.getThreadName());
            int n = 0;
            while (iterator.hasNext()) {
                Display display = iterator.next();
                System.err.println("  [" + n + "] : " + display);
                ++n;
            }
        }
    }

    public static Display getFirstDisplayOf(String string, String string2, int n, boolean bl) {
        return Display.getDisplayOfImpl(string, string2, n, 1, bl);
    }

    public static Display getLastDisplayOf(String string, String string2, int n, boolean bl) {
        return Display.getDisplayOfImpl(string, string2, n, -1, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Display getDisplayOfImpl(String string, String string2, int n, int n2, boolean bl) {
        ArrayList<Display> arrayList = displayList;
        synchronized (arrayList) {
            int n3;
            int n4 = n3 = n >= 0 ? n : displayList.size() - 1;
            while (n2 > 0 ? n3 < displayList.size() : n3 >= 0) {
                Display display = displayList.get(n3);
                if (display.getType().equals(string) && display.getName().equals(string2) && (!bl || bl && !display.isExclusive())) {
                    return display;
                }
                n3 += n2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Display> getAllDisplays() {
        ArrayList arrayList;
        ArrayList<Display> arrayList2 = displayList;
        synchronized (arrayList2) {
            arrayList = (ArrayList)displayList.clone();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getActiveDisplayNumber() {
        ArrayList<Display> arrayList = displayList;
        synchronized (arrayList) {
            return displaysActive;
        }
    }

    public static String getThreadName() {
        return Thread.currentThread().getName();
    }

    public static String toHexString(int n) {
        return "0x" + Integer.toHexString(n);
    }

    public static String toHexString(long l) {
        return "0x" + Long.toHexString(l);
    }

    public static int hashCodeNullSafe(Object object) {
        return null != object ? object.hashCode() : 0;
    }
}

