/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow;

import com.jogamp.common.util.ReflectionUtil;
import java.lang.reflect.Constructor;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.ToolkitLock;
import jogamp.nativewindow.NullToolkitLock;

public class NativeWindowFactoryImpl
extends NativeWindowFactory {
    private static final ToolkitLock nullToolkitLock = new NullToolkitLock();
    private Constructor<?> nativeWindowConstructor = null;

    public static ToolkitLock getNullToolkitLock() {
        return nullToolkitLock;
    }

    @Override
    protected NativeWindow getNativeWindowImpl(Object object, AbstractGraphicsConfiguration abstractGraphicsConfiguration) throws IllegalArgumentException {
        if (object instanceof NativeWindow) {
            return (NativeWindow)object;
        }
        if (null == abstractGraphicsConfiguration) {
            throw new IllegalArgumentException("AbstractGraphicsConfiguration is null with a non NativeWindow object");
        }
        if (NativeWindowFactory.isAWTAvailable() && ReflectionUtil.instanceOf((Object)object, (String)"java.awt.Component")) {
            return this.getAWTNativeWindow(object, abstractGraphicsConfiguration);
        }
        throw new IllegalArgumentException("Target window object type " + object.getClass().getName() + " is unsupported; expected " + "javax.media.nativewindow.NativeWindow or " + "java.awt.Component");
    }

    private NativeWindow getAWTNativeWindow(Object object, AbstractGraphicsConfiguration abstractGraphicsConfiguration) {
        if (this.nativeWindowConstructor == null) {
            try {
                String string;
                String string2 = NativeWindowFactoryImpl.getNativeWindowType(true);
                if (TYPE_WINDOWS == string2) {
                    string = "jogamp.nativewindow.jawt.windows.WindowsJAWTWindow";
                } else if (TYPE_MACOSX == string2) {
                    string = "jogamp.nativewindow.jawt.macosx.MacOSXJAWTWindow";
                } else if (TYPE_X11 == string2) {
                    string = "jogamp.nativewindow.jawt.x11.X11JAWTWindow";
                } else {
                    throw new IllegalArgumentException("Native windowing type " + string2 + " (custom) not yet supported, platform reported native windowing type: " + NativeWindowFactoryImpl.getNativeWindowType(false));
                }
                this.nativeWindowConstructor = ReflectionUtil.getConstructor((String)string, (Class[])new Class[]{Object.class, AbstractGraphicsConfiguration.class}, (ClassLoader)this.getClass().getClassLoader());
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception);
            }
        }
        try {
            return (NativeWindow)this.nativeWindowConstructor.newInstance(object, abstractGraphicsConfiguration);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }
}

