/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.PngHelper;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.chunks.ChunkRaw;
import jogamp.opengl.util.pngj.chunks.PngChunk;

public class PngChunkSBIT
extends PngChunk {
    private int graysb;
    private int alphasb;
    private int redsb;
    private int greensb;
    private int bluesb;

    public PngChunkSBIT(ImageInfo imageInfo) {
        super("sBIT", imageInfo);
    }

    @Override
    public boolean mustGoBeforeIDAT() {
        return true;
    }

    @Override
    public boolean mustGoBeforePLTE() {
        return true;
    }

    private int getLen() {
        int n;
        int n2 = n = this.imgInfo.greyscale ? 1 : 3;
        if (this.imgInfo.alpha) {
            ++n;
        }
        return n;
    }

    @Override
    public void parseFromChunk(ChunkRaw chunkRaw) {
        if (chunkRaw.len != this.getLen()) {
            throw new PngjException("bad chunk length " + chunkRaw);
        }
        if (this.imgInfo.greyscale) {
            this.graysb = PngHelper.readInt1fromByte(chunkRaw.data, 0);
            if (this.imgInfo.alpha) {
                this.alphasb = PngHelper.readInt1fromByte(chunkRaw.data, 1);
            }
        } else {
            this.redsb = PngHelper.readInt1fromByte(chunkRaw.data, 0);
            this.greensb = PngHelper.readInt1fromByte(chunkRaw.data, 1);
            this.bluesb = PngHelper.readInt1fromByte(chunkRaw.data, 2);
            if (this.imgInfo.alpha) {
                this.alphasb = PngHelper.readInt1fromByte(chunkRaw.data, 3);
            }
        }
    }

    @Override
    public ChunkRaw createChunk() {
        ChunkRaw chunkRaw = null;
        chunkRaw = this.createEmptyChunk(this.getLen(), true);
        if (this.imgInfo.greyscale) {
            chunkRaw.data[0] = (byte)this.graysb;
            if (this.imgInfo.alpha) {
                chunkRaw.data[1] = (byte)this.alphasb;
            }
        } else {
            chunkRaw.data[0] = (byte)this.redsb;
            chunkRaw.data[1] = (byte)this.greensb;
            chunkRaw.data[2] = (byte)this.bluesb;
            if (this.imgInfo.alpha) {
                chunkRaw.data[3] = (byte)this.alphasb;
            }
        }
        return chunkRaw;
    }

    @Override
    public void cloneDataFromRead(PngChunk pngChunk) {
        PngChunkSBIT pngChunkSBIT = (PngChunkSBIT)pngChunk;
        this.graysb = pngChunkSBIT.graysb;
        this.redsb = pngChunkSBIT.redsb;
        this.greensb = pngChunkSBIT.greensb;
        this.bluesb = pngChunkSBIT.bluesb;
        this.alphasb = pngChunkSBIT.alphasb;
    }

    public void setGraysb(int n) {
        if (!this.imgInfo.greyscale) {
            throw new PngjException("only greyscale images support this");
        }
        this.graysb = n;
    }

    public int getGraysb() {
        if (!this.imgInfo.greyscale) {
            throw new PngjException("only greyscale images support this");
        }
        return this.graysb;
    }

    public void setAlphasb(int n) {
        if (!this.imgInfo.alpha) {
            throw new PngjException("only images with alpha support this");
        }
        this.alphasb = n;
    }

    public int getAlphasb() {
        if (!this.imgInfo.alpha) {
            throw new PngjException("only images with alpha support this");
        }
        return this.alphasb;
    }

    public void setRGB(int n, int n2, int n3) {
        if (this.imgInfo.greyscale || this.imgInfo.indexed) {
            throw new PngjException("only rgb or rgba images support this");
        }
        this.redsb = n;
        this.greensb = n2;
        this.bluesb = n3;
    }

    public int[] getRGB() {
        if (this.imgInfo.greyscale || this.imgInfo.indexed) {
            throw new PngjException("only rgb or rgba images support this");
        }
        return new int[]{this.redsb, this.greensb, this.bluesb};
    }
}

