/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl;

import com.jogamp.common.os.Platform;
import java.nio.FloatBuffer;

public class FloatUtil {
    private static final float[] IDENTITY_MATRIX = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    private static final float[] ZERO_MATRIX = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};

    public static final void makeIdentityf(float[] fArray, int n) {
        for (int i = 0; i < 16; ++i) {
            fArray[i + n] = IDENTITY_MATRIX[i];
        }
    }

    public static final void makeIdentityf(FloatBuffer floatBuffer) {
        int n = floatBuffer.position();
        floatBuffer.put(IDENTITY_MATRIX);
        floatBuffer.position(n);
    }

    public static final void makeZero(float[] fArray, int n) {
        for (int i = 0; i < 16; ++i) {
            fArray[i + n] = 0.0f;
        }
    }

    public static final void makeZero(FloatBuffer floatBuffer) {
        int n = floatBuffer.position();
        floatBuffer.put(ZERO_MATRIX);
        floatBuffer.position(n);
    }

    public static final void multMatrixf(float[] fArray, int n, float[] fArray2, int n2, float[] fArray3, int n3) {
        for (int i = 0; i < 4; ++i) {
            float f = fArray[n + i + 0];
            float f2 = fArray[n + i + 4];
            float f3 = fArray[n + i + 8];
            float f4 = fArray[n + i + 12];
            fArray3[n3 + i + 0] = f * fArray2[n2 + 0 + 0] + f2 * fArray2[n2 + 1 + 0] + f3 * fArray2[n2 + 2 + 0] + f4 * fArray2[n2 + 3 + 0];
            fArray3[n3 + i + 4] = f * fArray2[n2 + 0 + 4] + f2 * fArray2[n2 + 1 + 4] + f3 * fArray2[n2 + 2 + 4] + f4 * fArray2[n2 + 3 + 4];
            fArray3[n3 + i + 8] = f * fArray2[n2 + 0 + 8] + f2 * fArray2[n2 + 1 + 8] + f3 * fArray2[n2 + 2 + 8] + f4 * fArray2[n2 + 3 + 8];
            fArray3[n3 + i + 12] = f * fArray2[n2 + 0 + 12] + f2 * fArray2[n2 + 1 + 12] + f3 * fArray2[n2 + 2 + 12] + f4 * fArray2[n2 + 3 + 12];
        }
    }

    public static final void multMatrixf(float[] fArray, int n, float[] fArray2, int n2, FloatBuffer floatBuffer) {
        int n3 = floatBuffer.position();
        for (int i = 0; i < 4; ++i) {
            float f = fArray[n + i + 0];
            float f2 = fArray[n + i + 4];
            float f3 = fArray[n + i + 8];
            float f4 = fArray[n + i + 12];
            floatBuffer.put(n3 + i + 0, f * fArray2[n2 + 0 + 0] + f2 * fArray2[n2 + 1 + 0] + f3 * fArray2[n2 + 2 + 0] + f4 * fArray2[n2 + 3 + 0]);
            floatBuffer.put(n3 + i + 4, f * fArray2[n2 + 0 + 4] + f2 * fArray2[n2 + 1 + 4] + f3 * fArray2[n2 + 2 + 4] + f4 * fArray2[n2 + 3 + 4]);
            floatBuffer.put(n3 + i + 8, f * fArray2[n2 + 0 + 8] + f2 * fArray2[n2 + 1 + 8] + f3 * fArray2[n2 + 2 + 8] + f4 * fArray2[n2 + 3 + 8]);
            floatBuffer.put(n3 + i + 12, f * fArray2[n2 + 0 + 12] + f2 * fArray2[n2 + 1 + 12] + f3 * fArray2[n2 + 2 + 12] + f4 * fArray2[n2 + 3 + 12]);
        }
    }

    public static final void multMatrixf(FloatBuffer floatBuffer, float[] fArray, int n, FloatBuffer floatBuffer2) {
        int n2 = floatBuffer.position();
        int n3 = floatBuffer2.position();
        for (int i = 0; i < 4; ++i) {
            float f = floatBuffer.get(n2 + i + 0);
            float f2 = floatBuffer.get(n2 + i + 4);
            float f3 = floatBuffer.get(n2 + i + 8);
            float f4 = floatBuffer.get(n2 + i + 12);
            floatBuffer2.put(n3 + i + 0, f * fArray[n + 0 + 0] + f2 * fArray[n + 1 + 0] + f3 * fArray[n + 2 + 0] + f4 * fArray[n + 3 + 0]);
            floatBuffer2.put(n3 + i + 4, f * fArray[n + 0 + 4] + f2 * fArray[n + 1 + 4] + f3 * fArray[n + 2 + 4] + f4 * fArray[n + 3 + 4]);
            floatBuffer2.put(n3 + i + 8, f * fArray[n + 0 + 8] + f2 * fArray[n + 1 + 8] + f3 * fArray[n + 2 + 8] + f4 * fArray[n + 3 + 8]);
            floatBuffer2.put(n3 + i + 12, f * fArray[n + 0 + 12] + f2 * fArray[n + 1 + 12] + f3 * fArray[n + 2 + 12] + f4 * fArray[n + 3 + 12]);
        }
    }

    public static final void multMatrixf(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3) {
        int n = floatBuffer.position();
        int n2 = floatBuffer2.position();
        int n3 = floatBuffer3.position();
        for (int i = 0; i < 4; ++i) {
            float f = floatBuffer.get(n + i + 0);
            float f2 = floatBuffer.get(n + i + 4);
            float f3 = floatBuffer.get(n + i + 8);
            float f4 = floatBuffer.get(n + i + 12);
            floatBuffer3.put(n3 + i + 0, f * floatBuffer2.get(n2 + 0 + 0) + f2 * floatBuffer2.get(n2 + 1 + 0) + f3 * floatBuffer2.get(n2 + 2 + 0) + f4 * floatBuffer2.get(n2 + 3 + 0));
            floatBuffer3.put(n3 + i + 4, f * floatBuffer2.get(n2 + 0 + 4) + f2 * floatBuffer2.get(n2 + 1 + 4) + f3 * floatBuffer2.get(n2 + 2 + 4) + f4 * floatBuffer2.get(n2 + 3 + 4));
            floatBuffer3.put(n3 + i + 8, f * floatBuffer2.get(n2 + 0 + 8) + f2 * floatBuffer2.get(n2 + 1 + 8) + f3 * floatBuffer2.get(n2 + 2 + 8) + f4 * floatBuffer2.get(n2 + 3 + 8));
            floatBuffer3.put(n3 + i + 12, f * floatBuffer2.get(n2 + 0 + 12) + f2 * floatBuffer2.get(n2 + 1 + 12) + f3 * floatBuffer2.get(n2 + 2 + 12) + f4 * floatBuffer2.get(n2 + 3 + 12));
        }
    }

    public static final void normalize(float[] fArray) {
        float f = (float)Math.sqrt(fArray[0] * fArray[0] + fArray[1] * fArray[1] + fArray[2] * fArray[2]);
        if ((double)f == 0.0 || (double)f == 1.0) {
            return;
        }
        f = 1.0f / f;
        fArray[0] = fArray[0] * f;
        fArray[1] = fArray[1] * f;
        fArray[2] = fArray[2] * f;
    }

    public static final void normalize(FloatBuffer floatBuffer) {
        int n = floatBuffer.position();
        float f = (float)Math.sqrt(floatBuffer.get(0 + n) * floatBuffer.get(0 + n) + floatBuffer.get(1 + n) * floatBuffer.get(1 + n) + floatBuffer.get(2 + n) * floatBuffer.get(2 + n));
        if ((double)f == 0.0 || (double)f == 1.0) {
            return;
        }
        f = 1.0f / f;
        floatBuffer.put(0 + n, floatBuffer.get(0 + n) * f);
        floatBuffer.put(1 + n, floatBuffer.get(1 + n) * f);
        floatBuffer.put(2 + n, floatBuffer.get(2 + n) * f);
    }

    public static final void cross(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray3[0] = fArray[1] * fArray2[2] - fArray[2] * fArray2[1];
        fArray3[1] = fArray[2] * fArray2[0] - fArray[0] * fArray2[2];
        fArray3[2] = fArray[0] * fArray2[1] - fArray[1] * fArray2[0];
    }

    public static final void cross(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3) {
        int n = floatBuffer.position();
        int n2 = floatBuffer2.position();
        int n3 = floatBuffer3.position();
        floatBuffer3.put(0 + n3, floatBuffer.get(1 + n) * floatBuffer2.get(2 + n2) - floatBuffer.get(2 + n) * floatBuffer2.get(1 + n2));
        floatBuffer3.put(1 + n3, floatBuffer.get(2 + n) * floatBuffer2.get(0 + n2) - floatBuffer.get(0 + n) * floatBuffer2.get(2 + n2));
        floatBuffer3.put(2 + n3, floatBuffer.get(0 + n) * floatBuffer2.get(1 + n2) - floatBuffer.get(1 + n) * floatBuffer2.get(0 + n2));
    }

    public static final void multMatrixVecf(float[] fArray, int n, float[] fArray2, int n2, float[] fArray3, int n3) {
        for (int i = 0; i < 4; ++i) {
            fArray3[i + n3] = fArray2[0 + n2] * fArray[0 + i + n] + fArray2[1 + n2] * fArray[4 + i + n] + fArray2[2 + n2] * fArray[8 + i + n] + fArray2[3 + n2] * fArray[12 + i + n];
        }
    }

    public static final void multMatrixVecf(float[] fArray, float[] fArray2, float[] fArray3) {
        for (int i = 0; i < 4; ++i) {
            fArray3[i] = fArray2[0] * fArray[0 + i] + fArray2[1] * fArray[4 + i] + fArray2[2] * fArray[8 + i] + fArray2[3] * fArray[12 + i];
        }
    }

    public static final void multMatrixVecf(FloatBuffer floatBuffer, float[] fArray, int n, float[] fArray2, int n2) {
        int n3 = floatBuffer.position();
        for (int i = 0; i < 4; ++i) {
            fArray2[i + n2] = fArray[0 + n] * floatBuffer.get(0 + i + n3) + fArray[1 + n] * floatBuffer.get(4 + i + n3) + fArray[2 + n] * floatBuffer.get(8 + i + n3) + fArray[3 + n] * floatBuffer.get(12 + i + n3);
        }
    }

    public static final void multMatrixVecf(FloatBuffer floatBuffer, float[] fArray, float[] fArray2) {
        int n = floatBuffer.position();
        for (int i = 0; i < 4; ++i) {
            fArray2[i] = fArray[0] * floatBuffer.get(0 + i + n) + fArray[1] * floatBuffer.get(4 + i + n) + fArray[2] * floatBuffer.get(8 + i + n) + fArray[3] * floatBuffer.get(12 + i + n);
        }
    }

    public static final void multMatrixVecf(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3) {
        int n = floatBuffer2.position();
        int n2 = floatBuffer3.position();
        int n3 = floatBuffer.position();
        for (int i = 0; i < 4; ++i) {
            floatBuffer3.put(i + n2, floatBuffer2.get(0 + n) * floatBuffer.get(0 + i + n3) + floatBuffer2.get(1 + n) * floatBuffer.get(4 + i + n3) + floatBuffer2.get(2 + n) * floatBuffer.get(8 + i + n3) + floatBuffer2.get(3 + n) * floatBuffer.get(12 + i + n3));
        }
    }

    public static StringBuilder matrixRowToString(StringBuilder stringBuilder, String string, FloatBuffer floatBuffer, int n, int n2, int n3, boolean bl, int n4) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        int n5 = n + floatBuffer.position();
        if (bl) {
            for (int i = 0; i < n3; ++i) {
                stringBuilder.append(String.format(string + " ", Float.valueOf(floatBuffer.get(n5 + n4 * n3 + i))));
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                stringBuilder.append(String.format(string + " ", Float.valueOf(floatBuffer.get(n5 + n4 + i * n2))));
            }
        }
        return stringBuilder;
    }

    public static StringBuilder matrixToString(StringBuilder stringBuilder, String string, String string2, FloatBuffer floatBuffer, int n, int n2, int n3, boolean bl) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        String string3 = null == string ? "" : string;
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append(string3).append("[ ");
            FloatUtil.matrixRowToString(stringBuilder, string2, floatBuffer, n, n2, n3, bl, i);
            stringBuilder.append("]").append(Platform.getNewline());
        }
        return stringBuilder;
    }

    public static StringBuilder matrixToString(StringBuilder stringBuilder, String string, String string2, FloatBuffer floatBuffer, int n, FloatBuffer floatBuffer2, int n2, int n3, int n4, boolean bl) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        String string3 = null == string ? "" : string;
        for (int i = 0; i < n3; ++i) {
            stringBuilder.append(string3).append("[ ");
            FloatUtil.matrixRowToString(stringBuilder, string2, floatBuffer, n, n3, n4, bl, i);
            stringBuilder.append("=?= ");
            FloatUtil.matrixRowToString(stringBuilder, string2, floatBuffer2, n2, n3, n4, bl, i);
            stringBuilder.append("]").append(Platform.getNewline());
        }
        return stringBuilder;
    }
}

