/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm.commons;

import org.jruby.org.objectweb.asm.ModuleVisitor;
import org.jruby.org.objectweb.asm.commons.Remapper;

public class ModuleRemapper
extends ModuleVisitor {
    private final Remapper remapper;

    public ModuleRemapper(ModuleVisitor mv, Remapper remapper) {
        this(393216, mv, remapper);
    }

    protected ModuleRemapper(int api, ModuleVisitor mv, Remapper remapper) {
        super(api, mv);
        this.remapper = remapper;
    }

    public void visitMainClass(String mainClass) {
        super.visitMainClass(this.remapper.mapType(mainClass));
    }

    public void visitPackage(String packaze) {
        super.visitPackage(this.remapper.mapPackageName(packaze));
    }

    public void visitRequire(String module, int access, String version) {
        super.visitRequire(this.remapper.mapModuleName(module), access, version);
    }

    public void visitExport(String packaze, int access, String ... modules) {
        String[] newModules = null;
        if (modules != null) {
            newModules = new String[modules.length];
            for (int i2 = 0; i2 < modules.length; ++i2) {
                newModules[i2] = this.remapper.mapModuleName(modules[i2]);
            }
        }
        super.visitExport(this.remapper.mapPackageName(packaze), access, newModules);
    }

    public void visitOpen(String packaze, int access, String ... modules) {
        String[] newModules = null;
        if (modules != null) {
            newModules = new String[modules.length];
            for (int i2 = 0; i2 < modules.length; ++i2) {
                newModules[i2] = this.remapper.mapModuleName(modules[i2]);
            }
        }
        super.visitOpen(this.remapper.mapPackageName(packaze), access, newModules);
    }

    public void visitUse(String service) {
        super.visitUse(this.remapper.mapType(service));
    }

    public void visitProvide(String service, String ... providers) {
        String[] newProviders = new String[providers.length];
        for (int i2 = 0; i2 < providers.length; ++i2) {
            newProviders[i2] = this.remapper.mapType(providers[i2]);
        }
        super.visitProvide(this.remapper.mapType(service), newProviders);
    }
}

