/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.anx.v2;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.anx.v2.dto.ANXValue;
import org.knowm.xchange.anx.v2.dto.account.ANXAccountInfo;
import org.knowm.xchange.anx.v2.dto.account.ANXWallet;
import org.knowm.xchange.anx.v2.dto.account.ANXWalletHistoryEntry;
import org.knowm.xchange.anx.v2.dto.marketdata.ANXOrder;
import org.knowm.xchange.anx.v2.dto.marketdata.ANXTicker;
import org.knowm.xchange.anx.v2.dto.marketdata.ANXTrade;
import org.knowm.xchange.anx.v2.dto.meta.ANXMetaData;
import org.knowm.xchange.anx.v2.dto.trade.ANXOpenOrder;
import org.knowm.xchange.anx.v2.dto.trade.ANXTradeResult;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.meta.CurrencyPairMetaData;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.utils.DateUtils;

public final class ANXAdapters {
    private static final int PERCENT_DECIMAL_SHIFT = 2;

    private ANXAdapters() {
    }

    public static AccountInfo adaptAccountInfo(ANXAccountInfo anxAccountInfo) {
        AccountInfo accountInfo = new AccountInfo(anxAccountInfo.getLogin(), ANXAdapters.percentToFactor(anxAccountInfo.getTradeFee()), new Wallet[]{ANXAdapters.adaptWallet(anxAccountInfo.getWallets())});
        return accountInfo;
    }

    public static BigDecimal percentToFactor(BigDecimal percent) {
        return percent.movePointLeft(2);
    }

    public static LimitOrder adaptOrder(BigDecimal amount, BigDecimal price, String tradedCurrency, String transactionCurrency, String orderTypeString, String id, Date timestamp) {
        Order.OrderType orderType = ANXAdapters.adaptSide(orderTypeString);
        CurrencyPair currencyPair = ANXAdapters.adaptCurrencyPair(tradedCurrency, transactionCurrency);
        LimitOrder limitOrder = new LimitOrder(orderType, amount, currencyPair, id, timestamp, price);
        return limitOrder;
    }

    public static List<LimitOrder> adaptOrders(List<ANXOrder> anxOrders, String tradedCurrency, String currency, String orderType, String id) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        for (ANXOrder anxOrder : anxOrders) {
            limitOrders.add(ANXAdapters.adaptOrder(anxOrder.getAmount(), anxOrder.getPrice(), tradedCurrency, currency, orderType, id, new Date(anxOrder.getStamp())));
        }
        return limitOrders;
    }

    public static List<LimitOrder> adaptOrders(ANXOpenOrder[] anxOpenOrders) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        for (ANXOpenOrder anxOpenOrder : anxOpenOrders) {
            limitOrders.add(ANXAdapters.adaptOrder(anxOpenOrder.getAmount().getValue(), anxOpenOrder.getPrice().getValue(), anxOpenOrder.getItem(), anxOpenOrder.getCurrency(), anxOpenOrder.getType(), anxOpenOrder.getOid(), new Date(anxOpenOrder.getDate())));
        }
        return limitOrders;
    }

    public static Balance adaptBalance(ANXWallet anxWallet) {
        if (anxWallet == null) {
            return null;
        }
        return new Balance(Currency.getInstance((String)anxWallet.getBalance().getCurrency()), anxWallet.getBalance().getValue(), anxWallet.getAvailableBalance().getValue());
    }

    public static Wallet adaptWallet(Map<String, ANXWallet> anxWallets) {
        ArrayList<Balance> balances = new ArrayList<Balance>();
        for (ANXWallet anxWallet : anxWallets.values()) {
            Balance balance = ANXAdapters.adaptBalance(anxWallet);
            if (balance == null) continue;
            balances.add(balance);
        }
        return new Wallet(balances);
    }

    public static Trades adaptTrades(List<ANXTrade> anxTrades) {
        ArrayList<Trade> tradesList = new ArrayList<Trade>();
        long latestTid = 0L;
        for (ANXTrade anxTrade : anxTrades) {
            long tid = anxTrade.getTid();
            if (tid > latestTid) {
                latestTid = tid;
            }
            tradesList.add(ANXAdapters.adaptTrade(anxTrade));
        }
        return new Trades(tradesList, latestTid, Trades.TradeSortType.SortByID);
    }

    public static Trade adaptTrade(ANXTrade anxTrade) {
        Order.OrderType orderType = ANXAdapters.adaptSide(anxTrade.getTradeType());
        BigDecimal amount = anxTrade.getAmount();
        BigDecimal price = anxTrade.getPrice();
        CurrencyPair currencyPair = ANXAdapters.adaptCurrencyPair(anxTrade.getItem(), anxTrade.getPriceCurrency());
        Date dateTime = DateUtils.fromMillisUtc((long)anxTrade.getTid());
        String tradeId = String.valueOf(anxTrade.getTid());
        return new Trade(orderType, amount, currencyPair, price, dateTime, tradeId);
    }

    public static Ticker adaptTicker(ANXTicker anxTicker) {
        BigDecimal volume = anxTicker.getVol().getValue();
        BigDecimal last = anxTicker.getLast().getValue();
        BigDecimal bid = anxTicker.getBuy().getValue();
        BigDecimal ask = anxTicker.getSell().getValue();
        BigDecimal high = anxTicker.getHigh().getValue();
        BigDecimal low = anxTicker.getLow().getValue();
        Date timestamp = new Date(anxTicker.getNow() / 1000L);
        CurrencyPair currencyPair = ANXAdapters.adaptCurrencyPair(anxTicker.getVol().getCurrency(), anxTicker.getAvg().getCurrency());
        return new Ticker.Builder().currencyPair(currencyPair).last(last).bid(bid).ask(ask).high(high).low(low).volume(volume).timestamp(timestamp).build();
    }

    public static CurrencyPair adaptCurrencyPair(String tradeCurrency, String priceCurrency) {
        return new CurrencyPair(tradeCurrency, priceCurrency);
    }

    public static UserTrades adaptUserTrades(ANXTradeResult[] anxTradeResults, ANXMetaData meta) {
        ArrayList<UserTrade> trades = new ArrayList<UserTrade>(anxTradeResults.length);
        for (ANXTradeResult tradeResult : anxTradeResults) {
            trades.add(ANXAdapters.adaptUserTrade(tradeResult, meta));
        }
        long lastId = trades.size() > 0 ? anxTradeResults[0].getTimestamp().getTime() : 0L;
        return new UserTrades(trades, lastId, Trades.TradeSortType.SortByTimestamp);
    }

    private static UserTrade adaptUserTrade(ANXTradeResult aNXTradeResult, ANXMetaData meta) {
        BigDecimal tradedCurrencyFillAmount = aNXTradeResult.getTradedCurrencyFillAmount();
        CurrencyPair currencyPair = ANXAdapters.adaptCurrencyPair(aNXTradeResult.getCurrencyPair());
        int priceScale = ((CurrencyPairMetaData)meta.getCurrencyPairs().get(currencyPair)).getPriceScale();
        BigDecimal price = aNXTradeResult.getSettlementCurrencyFillAmount().divide(tradedCurrencyFillAmount, priceScale, 6);
        Order.OrderType type = ANXAdapters.adaptSide(aNXTradeResult.getSide());
        return new UserTrade(type, tradedCurrencyFillAmount, currencyPair, price, aNXTradeResult.getTimestamp(), aNXTradeResult.getTradeId(), aNXTradeResult.getOrderId(), null, (Currency)null);
    }

    private static CurrencyPair adaptCurrencyPair(String currencyPairRaw) {
        if ("DOGEBTC".equalsIgnoreCase(currencyPairRaw)) {
            return CurrencyPair.DOGE_BTC;
        }
        if ("STARTBTC".equalsIgnoreCase(currencyPairRaw)) {
            return new CurrencyPair(Currency.START, Currency.BTC);
        }
        if (currencyPairRaw.length() != 6) {
            throw new IllegalArgumentException("Unrecognized currency pair " + currencyPairRaw);
        }
        return new CurrencyPair(currencyPairRaw.substring(0, 3), currencyPairRaw.substring(3));
    }

    private static Order.OrderType adaptSide(String side) {
        switch (side.toUpperCase()) {
            case "BUY": {
                return Order.OrderType.BID;
            }
            case "SELL": {
                return Order.OrderType.ASK;
            }
            case "BID": {
                return Order.OrderType.BID;
            }
            case "OFFER": {
                return Order.OrderType.ASK;
            }
            case "ASK": {
                return Order.OrderType.ASK;
            }
        }
        throw new IllegalStateException("Don't understand order direction: " + side);
    }

    public static FundingRecord adaptFundingRecord(ANXWalletHistoryEntry entry) {
        FundingRecord.Type type;
        String entryType = entry.getType();
        if (entryType.equalsIgnoreCase("deposit")) {
            type = FundingRecord.Type.DEPOSIT;
        } else if (entryType.equalsIgnoreCase("withdraw")) {
            type = FundingRecord.Type.WITHDRAWAL;
        } else {
            throw new IllegalStateException("should not get here");
        }
        Date date = DateUtils.fromMillisUtc((long)Long.valueOf(entry.getDate()));
        ANXValue value = entry.getValue();
        Currency currency = new Currency(value.getCurrency());
        ANXValue balance = entry.getBalance();
        return new FundingRecord(entry.getInfo(), date, currency, value.getValue(), null, null, type, FundingRecord.Status.COMPLETE, balance.getValue(), null, null);
    }
}

