/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.anx.v2;

import java.io.InputStream;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.anx.v2.dto.meta.ANXMetaData;
import org.knowm.xchange.anx.v2.service.ANXAccountService;
import org.knowm.xchange.anx.v2.service.ANXMarketDataService;
import org.knowm.xchange.anx.v2.service.ANXTradeService;
import org.knowm.xchange.utils.nonce.CurrentTimeNonceFactory;
import si.mazi.rescu.SynchronizedValueFactory;

public class ANXExchange
extends BaseExchange {
    private SynchronizedValueFactory<Long> nonceFactory = new CurrentTimeNonceFactory();
    private ANXMetaData anxMetaData;

    protected void initServices() {
        this.marketDataService = new ANXMarketDataService((Exchange)this);
        this.tradeService = new ANXTradeService(this);
        this.accountService = new ANXAccountService(this);
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(((Object)((Object)this)).getClass().getCanonicalName());
        exchangeSpecification.setSslUri("https://anxpro.com");
        exchangeSpecification.setHost("anxpro.com");
        exchangeSpecification.setPort(443);
        exchangeSpecification.setExchangeName("ANXPRO");
        exchangeSpecification.setExchangeDescription("Asia Nexgen is a Bitcoin exchange registered in Hong Kong.");
        return exchangeSpecification;
    }

    public SynchronizedValueFactory<Long> getNonceFactory() {
        return this.nonceFactory;
    }

    public ANXMetaData getANXMetaData() {
        return this.anxMetaData;
    }

    protected void loadExchangeMetaData(InputStream is) {
        this.anxMetaData = (ANXMetaData)((Object)this.loadMetaData(is, ANXMetaData.class));
        this.exchangeMetaData = this.anxMetaData;
    }
}

