/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.anx.v2.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.List;
import org.knowm.xchange.anx.v2.dto.marketdata.ANXOrder;

public final class ANXDepth {
    private final List<ANXOrder> asks;
    private final List<ANXOrder> bids;
    private final FilterPrice filterMinPrice;
    private final FilterPrice filterMaxPrice;
    private final Long microTime;

    public ANXDepth(@JsonProperty(value="now") Long microTime, @JsonProperty(value="asks") List<ANXOrder> asks, @JsonProperty(value="bids") List<ANXOrder> bids, @JsonProperty(value="filter_min_price") FilterPrice filterMinPrice, @JsonProperty(value="filter_max_price") FilterPrice filterMaxPrice) {
        this.asks = asks;
        this.bids = bids;
        this.filterMinPrice = filterMinPrice;
        this.filterMaxPrice = filterMaxPrice;
        this.microTime = microTime;
    }

    public List<ANXOrder> getAsks() {
        return this.asks;
    }

    public List<ANXOrder> getBids() {
        return this.bids;
    }

    public FilterPrice getFilterMinPrice() {
        return this.filterMinPrice;
    }

    public FilterPrice getFilterMaxPrice() {
        return this.filterMaxPrice;
    }

    public Long getMicroTime() {
        return this.microTime;
    }

    public String toString() {
        return "ANXDepth [asks=" + this.asks.toString() + ", bids=" + this.bids.toString() + "]";
    }

    public static class FilterPrice {
        private final BigDecimal value;
        private final long valueInt;
        private final String currency;

        public FilterPrice(@JsonProperty(value="value") BigDecimal value, @JsonProperty(value="value_int") long valueInt, @JsonProperty(value="currency") String currency) {
            this.value = value;
            this.valueInt = valueInt;
            this.currency = currency;
        }

        public BigDecimal getValue() {
            return this.value;
        }

        public long getValueInt() {
            return this.valueInt;
        }

        public String getCurrency() {
            return this.currency;
        }
    }
}

