/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.anx.v2.dto.meta;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Map;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.meta.CurrencyMetaData;
import org.knowm.xchange.dto.meta.CurrencyPairMetaData;
import org.knowm.xchange.dto.meta.ExchangeMetaData;
import org.knowm.xchange.dto.meta.RateLimit;

public class ANXMetaData
extends ExchangeMetaData {
    @JsonProperty(value="maker_trading_fee")
    private final BigDecimal makerTradingFee;
    @JsonProperty(value="taker_trading_fee")
    private final BigDecimal takerTradingFee;

    public ANXMetaData(@JsonProperty(value="currency_pairs") Map<CurrencyPair, CurrencyPairMetaData> currencyPairs, @JsonProperty(value="currencies") Map<Currency, CurrencyMetaData> currencies, @JsonProperty(value="public_rate_limits") RateLimit[] publicRateLimits, @JsonProperty(value="private_rate_limits") RateLimit[] privateRateLimits, @JsonProperty(value="share_rate_limits") Boolean shareRateLimits, @JsonProperty(value="maker_trading_fee") BigDecimal makerTradingFee, @JsonProperty(value="taker_trading_fee") BigDecimal takerTradingFee) {
        super(currencyPairs, currencies, publicRateLimits, privateRateLimits, shareRateLimits);
        this.makerTradingFee = makerTradingFee;
        this.takerTradingFee = takerTradingFee;
    }

    public BigDecimal getMakerTradingFee() {
        return this.makerTradingFee;
    }

    public BigDecimal getTakerTradingFee() {
        return this.takerTradingFee;
    }
}

