/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.anx.v2.dto.trade;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.knowm.xchange.anx.v2.dto.ANXValue;
import org.knowm.xchange.anx.v2.dto.trade.ANXOrderResultTrade;

public final class ANXOrderResult {
    private final ANXValue avgCost;
    private final String orderId;
    private final ANXValue totalAmount;
    private final ANXValue totalSpent;
    private final ANXOrderResultTrade[] trades;

    public ANXOrderResult(@JsonProperty(value="avg_cost") ANXValue avgCost, @JsonProperty(value="order_id") String orderId, @JsonProperty(value="total_amount") ANXValue totalAmount, @JsonProperty(value="total_spent") ANXValue totalSpent, @JsonProperty(value="trades") ANXOrderResultTrade[] trades) {
        this.avgCost = avgCost;
        this.orderId = orderId;
        this.totalAmount = totalAmount;
        this.totalSpent = totalSpent;
        this.trades = trades;
    }

    public ANXValue getAvgCost() {
        return this.avgCost;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public ANXValue getTotalAmount() {
        return this.totalAmount;
    }

    public ANXValue getTotalSpent() {
        return this.totalSpent;
    }

    public ANXOrderResultTrade[] getTrades() {
        return this.trades;
    }

    public String toString() {
        StringBuilder tradesString = new StringBuilder("[");
        for (int i = 0; i < this.trades.length; ++i) {
            tradesString.append(i > 0 ? ", " : "").append(this.trades[i].toString());
        }
        tradesString.append("]");
        return "ANXOpenOrder [avgCost=" + this.avgCost + ", orderId=" + this.orderId + ", totalAmount=" + this.totalAmount + ", totalSpent=" + this.totalSpent + ", trades=" + tradesString + "]";
    }
}

