/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.anx.v2.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.anx.v2.ANXAdapters;
import org.knowm.xchange.anx.v2.dto.account.ANXWalletHistoryEntry;
import org.knowm.xchange.anx.v2.dto.account.ANXWithdrawalResponse;
import org.knowm.xchange.anx.v2.dto.account.ANXWithdrawalResponseWrapper;
import org.knowm.xchange.anx.v2.service.ANXAccountServiceRaw;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.DefaultWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrency;
import org.knowm.xchange.service.trade.params.TradeHistoryParamPaging;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;
import org.knowm.xchange.service.trade.params.WithdrawFundsParams;

public class ANXAccountService
extends ANXAccountServiceRaw
implements AccountService {
    public ANXAccountService(BaseExchange baseExchange) {
        super((Exchange)baseExchange);
    }

    public AccountInfo getAccountInfo() throws IOException {
        return ANXAdapters.adaptAccountInfo(this.getANXAccountInfo());
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, String address) throws IOException {
        if (amount.scale() > 8) {
            throw new IllegalArgumentException("Amount scale exceed 8");
        }
        if (address == null) {
            throw new IllegalArgumentException("Amount cannot be null");
        }
        ANXWithdrawalResponseWrapper wrapper = this.anxWithdrawFunds(currency.toString(), amount, address);
        ANXWithdrawalResponse response = wrapper.getAnxWithdrawalResponse();
        if (wrapper.getResult().equals("error")) {
            throw new IllegalStateException("Failed to withdraw funds: " + response.getMessage());
        }
        if (wrapper.getError() != null) {
            throw new IllegalStateException("Failed to withdraw funds: " + wrapper.getError());
        }
        return response.getTransactionId();
    }

    public String withdrawFunds(WithdrawFundsParams params) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        if (params instanceof DefaultWithdrawFundsParams) {
            DefaultWithdrawFundsParams defaultParams = (DefaultWithdrawFundsParams)params;
            return this.withdrawFunds(defaultParams.currency, defaultParams.amount, defaultParams.address);
        }
        throw new IllegalStateException("Don't know how to withdraw: " + params);
    }

    public String requestDepositAddress(Currency currency, String ... args) throws IOException {
        return this.anxRequestDepositAddress(currency.toString()).getAddress();
    }

    public TradeHistoryParams createFundingHistoryParams() {
        throw new NotAvailableFromExchangeException();
    }

    public List<FundingRecord> getFundingHistory(TradeHistoryParams params) throws IOException {
        ArrayList<FundingRecord> results = new ArrayList<FundingRecord>();
        List<ANXWalletHistoryEntry> walletHistory = this.getWalletHistory(params);
        for (ANXWalletHistoryEntry entry : walletHistory) {
            if (!entry.getType().equalsIgnoreCase("deposit") && !entry.getType().equalsIgnoreCase("withdraw")) continue;
            results.add(ANXAdapters.adaptFundingRecord(entry));
        }
        return results;
    }

    public static class AnxFundingHistoryParams
    implements TradeHistoryParamCurrency,
    TradeHistoryParamPaging,
    TradeHistoryParamsTimeSpan {
        private Currency currency;
        private Integer pageNumber;
        private Integer pageLength;
        private Date startTime;
        private Date endTime;

        public AnxFundingHistoryParams() {
        }

        public AnxFundingHistoryParams(Currency currency, Date startTime, Date endTime) {
            this.currency = currency;
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public void setCurrency(Currency currency) {
            this.currency = currency;
        }

        public Currency getCurrency() {
            return this.currency;
        }

        public void setPageLength(Integer pageLength) {
        }

        public Integer getPageLength() {
            return this.pageLength;
        }

        public void setPageNumber(Integer pageNumber) {
            if (pageNumber != null && pageNumber == 0) {
                throw new IllegalStateException("Pages are '1' indexed");
            }
            this.pageNumber = pageNumber;
        }

        public Integer getPageNumber() {
            return this.pageNumber;
        }

        public void setStartTime(Date startTime) {
            this.startTime = startTime;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public void setEndTime(Date endTime) {
            this.endTime = endTime;
        }

        public Date getEndTime() {
            return this.endTime;
        }
    }
}

