/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.anx.v2.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.anx.v2.ANXV2;
import org.knowm.xchange.anx.v2.dto.ANXException;
import org.knowm.xchange.anx.v2.dto.account.ANXAccountInfo;
import org.knowm.xchange.anx.v2.dto.account.ANXAccountInfoWrapper;
import org.knowm.xchange.anx.v2.dto.account.ANXBitcoinDepositAddress;
import org.knowm.xchange.anx.v2.dto.account.ANXBitcoinDepositAddressWrapper;
import org.knowm.xchange.anx.v2.dto.account.ANXWalletHistory;
import org.knowm.xchange.anx.v2.dto.account.ANXWalletHistoryEntry;
import org.knowm.xchange.anx.v2.dto.account.ANXWalletHistoryWrapper;
import org.knowm.xchange.anx.v2.dto.account.ANXWithdrawalResponseWrapper;
import org.knowm.xchange.anx.v2.service.ANXBaseService;
import org.knowm.xchange.anx.v2.service.ANXV2Digest;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrency;
import org.knowm.xchange.service.trade.params.TradeHistoryParamPaging;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;
import org.knowm.xchange.utils.Assert;
import org.knowm.xchange.utils.DateUtils;
import si.mazi.rescu.HttpStatusIOException;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestProxyFactory;
import si.mazi.rescu.SynchronizedValueFactory;

public class ANXAccountServiceRaw
extends ANXBaseService {
    private final ANXV2 anxV2;
    private final ANXV2Digest signatureCreator;

    protected ANXAccountServiceRaw(Exchange exchange) {
        super(exchange);
        Assert.notNull((Object)exchange.getExchangeSpecification().getSslUri(), (String)"Exchange specification URI cannot be null");
        this.anxV2 = (ANXV2)RestProxyFactory.createProxy(ANXV2.class, (String)exchange.getExchangeSpecification().getSslUri());
        this.signatureCreator = ANXV2Digest.createInstance(exchange.getExchangeSpecification().getSecretKey());
    }

    public ANXAccountInfo getANXAccountInfo() throws IOException {
        try {
            ANXAccountInfoWrapper anxAccountInfoWrapper = this.anxV2.getAccountInfo(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
            return anxAccountInfoWrapper.getANXAccountInfo();
        }
        catch (ANXException e) {
            throw this.handleError(e);
        }
        catch (HttpStatusIOException e) {
            throw this.handleHttpError(e);
        }
    }

    public ANXWithdrawalResponseWrapper anxWithdrawFunds(String currency, BigDecimal amount, String address) throws IOException {
        try {
            ANXWithdrawalResponseWrapper anxWithdrawalResponseWrapper = this.anxV2.withdrawBtc(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), currency, address, amount.multiply(new BigDecimal(100000000)).intValue(), 1, false, false);
            return anxWithdrawalResponseWrapper;
        }
        catch (ANXException e) {
            throw this.handleError(e);
        }
        catch (HttpStatusIOException e) {
            throw this.handleHttpError(e);
        }
    }

    public ANXBitcoinDepositAddress anxRequestDepositAddress(String currency) throws IOException {
        try {
            ANXBitcoinDepositAddressWrapper anxBitcoinDepositAddressWrapper = this.anxV2.requestDepositAddress(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), currency);
            return anxBitcoinDepositAddressWrapper.getAnxBitcoinDepositAddress();
        }
        catch (ANXException e) {
            throw this.handleError(e);
        }
        catch (HttpStatusIOException e) {
            throw this.handleHttpError(e);
        }
    }

    public List<ANXWalletHistoryEntry> getWalletHistory(TradeHistoryParams params) throws IOException {
        String currencyCode = null;
        if (params instanceof TradeHistoryParamCurrency) {
            Currency currency = ((TradeHistoryParamCurrency)params).getCurrency();
            currencyCode = currency == null ? null : currency.getCurrencyCode();
        }
        Integer pageNumber = null;
        if (params instanceof TradeHistoryParamPaging) {
            pageNumber = ((TradeHistoryParamPaging)params).getPageNumber();
        }
        boolean userSpecifiedPageNumber = pageNumber != null;
        Date from = null;
        Date to = null;
        if (params instanceof TradeHistoryParamsTimeSpan) {
            TradeHistoryParamsTimeSpan tradeHistoryParamsTimeSpan = (TradeHistoryParamsTimeSpan)params;
            from = tradeHistoryParamsTimeSpan.getStartTime();
            to = tradeHistoryParamsTimeSpan.getEndTime();
        }
        ArrayList<ANXWalletHistoryEntry> all = new ArrayList<ANXWalletHistoryEntry>();
        ANXWalletHistory walletHistory = this.getWalletHistory(currencyCode, pageNumber, from, to);
        all.addAll(Arrays.asList(walletHistory.getANXWalletHistoryEntries()));
        while (walletHistory.getRecords() == walletHistory.getMaxResults() && !userSpecifiedPageNumber) {
            pageNumber = walletHistory.getCurrentPage() + 1;
            walletHistory = this.getWalletHistory(currencyCode, pageNumber, from, to);
            all.addAll(Arrays.asList(walletHistory.getANXWalletHistoryEntries()));
        }
        return all;
    }

    public ANXWalletHistory getWalletHistory(String currency, Integer page, Date from, Date to) throws IOException {
        try {
            ANXWalletHistoryWrapper walletHistory = this.anxV2.getWalletHistory(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), currency, page, DateUtils.toMillisNullSafe((Date)from), DateUtils.toMillisNullSafe((Date)to));
            return walletHistory.getANXWalletHistory();
        }
        catch (ANXException e) {
            throw this.handleError(e);
        }
        catch (HttpStatusIOException e) {
            throw this.handleHttpError(e);
        }
    }
}

