/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.anx.v2.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.anx.ANXUtils;
import org.knowm.xchange.anx.v2.ANXAdapters;
import org.knowm.xchange.anx.v2.ANXExchange;
import org.knowm.xchange.anx.v2.dto.trade.ANXTradeResultWrapper;
import org.knowm.xchange.anx.v2.service.ANXTradeServiceRaw;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.DefaultTradeHistoryParamsTimeSpan;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;
import org.knowm.xchange.utils.Assert;
import org.knowm.xchange.utils.DateUtils;

public class ANXTradeService
extends ANXTradeServiceRaw
implements TradeService {
    public ANXTradeService(BaseExchange baseExchange) {
        super((Exchange)baseExchange);
    }

    public OpenOrders getOpenOrders() throws IOException {
        return this.getOpenOrders(this.createOpenOrdersParams());
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws IOException {
        return new OpenOrders(ANXAdapters.adaptOrders(this.getANXOpenOrders()));
    }

    public String placeMarketOrder(MarketOrder marketOrder) throws IOException {
        return this.placeANXMarketOrder(marketOrder).getDataString();
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        Assert.notNull((Object)limitOrder.getLimitPrice(), (String)"getLimitPrice() cannot be null");
        Assert.notNull((Object)limitOrder.getTradableAmount(), (String)"getTradableAmount() cannot be null");
        if (limitOrder.getTradableAmount().scale() > 8) {
            throw new IllegalArgumentException("tradableAmount scale exceeds max");
        }
        if (limitOrder.getLimitPrice().scale() > ANXUtils.getMaxPriceScale(limitOrder.getCurrencyPair())) {
            throw new IllegalArgumentException("price scale exceeds max");
        }
        String type = limitOrder.getType().equals((Object)Order.OrderType.BID) ? "bid" : "ask";
        BigDecimal amount = limitOrder.getTradableAmount();
        BigDecimal price = limitOrder.getLimitPrice();
        return this.placeANXLimitOrder(limitOrder.getCurrencyPair(), type, amount, price).getDataString();
    }

    public boolean cancelOrder(String orderId) throws IOException {
        Assert.notNull((Object)orderId, (String)"orderId cannot be null");
        return this.cancelANXOrder(orderId, "BTC", "EUR").getResult().equals("success");
    }

    public boolean cancelOrder(CancelOrderParams orderParams) throws IOException {
        if (orderParams instanceof CancelOrderByIdParams) {
            this.cancelOrder(((CancelOrderByIdParams)orderParams).orderId);
        }
        return false;
    }

    private UserTrades getTradeHistory(Long from, Long to) throws IOException {
        ANXTradeResultWrapper rawTrades = this.getExecutedANXTrades(from, to);
        String error = rawTrades.getError();
        if (error != null) {
            throw new IllegalStateException(error);
        }
        return ANXAdapters.adaptUserTrades(rawTrades.getAnxTradeResults(), ((ANXExchange)this.exchange).getANXMetaData());
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws IOException {
        Long from = null;
        Long to = null;
        if (params instanceof TradeHistoryParamsTimeSpan) {
            TradeHistoryParamsTimeSpan p = (TradeHistoryParamsTimeSpan)params;
            from = DateUtils.toMillisNullSafe((Date)p.getStartTime());
            to = DateUtils.toMillisNullSafe((Date)p.getEndTime());
        }
        return this.getTradeHistory(from, to);
    }

    public TradeHistoryParams createTradeHistoryParams() {
        return new DefaultTradeHistoryParamsTimeSpan();
    }

    public OpenOrdersParams createOpenOrdersParams() {
        return null;
    }

    public Collection<Order> getOrder(String ... orderIds) throws IOException {
        throw new NotYetImplementedForExchangeException();
    }
}

