/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.anx.v2.service;

import java.io.IOException;
import java.math.BigDecimal;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.anx.ANXUtils;
import org.knowm.xchange.anx.v2.ANXV2;
import org.knowm.xchange.anx.v2.dto.ANXException;
import org.knowm.xchange.anx.v2.dto.trade.ANXGenericResponse;
import org.knowm.xchange.anx.v2.dto.trade.ANXOpenOrder;
import org.knowm.xchange.anx.v2.dto.trade.ANXOpenOrderWrapper;
import org.knowm.xchange.anx.v2.dto.trade.ANXOrderResultWrapper;
import org.knowm.xchange.anx.v2.dto.trade.ANXTradeResultWrapper;
import org.knowm.xchange.anx.v2.service.ANXBaseService;
import org.knowm.xchange.anx.v2.service.ANXV2Digest;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.utils.Assert;
import si.mazi.rescu.HttpStatusIOException;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestProxyFactory;
import si.mazi.rescu.SynchronizedValueFactory;

public class ANXTradeServiceRaw
extends ANXBaseService {
    private final ANXV2 anxV2;
    private final ANXV2Digest signatureCreator;

    protected ANXTradeServiceRaw(Exchange exchange) {
        super(exchange);
        Assert.notNull((Object)exchange.getExchangeSpecification().getSslUri(), (String)"Exchange specification URI cannot be null");
        this.anxV2 = (ANXV2)RestProxyFactory.createProxy(ANXV2.class, (String)exchange.getExchangeSpecification().getSslUri());
        this.signatureCreator = ANXV2Digest.createInstance(exchange.getExchangeSpecification().getSecretKey());
    }

    public ANXOpenOrder[] getANXOpenOrders(String baseCurrency, String counterCurrency) throws IOException {
        try {
            ANXOpenOrderWrapper anxOpenOrderWrapper = this.anxV2.getOpenOrders(ANXUtils.urlEncode(this.exchange.getExchangeSpecification().getApiKey()), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), baseCurrency, counterCurrency);
            return anxOpenOrderWrapper.getANXOpenOrders();
        }
        catch (ANXException e) {
            throw this.handleError(e);
        }
        catch (HttpStatusIOException e) {
            throw this.handleHttpError(e);
        }
    }

    public ANXOpenOrder[] getANXOpenOrders() throws IOException {
        try {
            ANXOpenOrderWrapper anxOpenOrderWrapper = this.anxV2.getOpenOrders(ANXUtils.urlEncode(this.exchange.getExchangeSpecification().getApiKey()), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
            return anxOpenOrderWrapper.getANXOpenOrders();
        }
        catch (ANXException e) {
            throw this.handleError(e);
        }
        catch (HttpStatusIOException e) {
            throw this.handleHttpError(e);
        }
    }

    public ANXGenericResponse placeANXMarketOrder(MarketOrder marketOrder) throws IOException {
        try {
            ANXGenericResponse anxGenericResponse = this.anxV2.placeOrder(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), marketOrder.getCurrencyPair().base.getCurrencyCode(), marketOrder.getCurrencyPair().counter.getCurrencyCode(), marketOrder.getType().equals((Object)Order.OrderType.BID) ? "bid" : "ask", marketOrder.getTradableAmount(), null);
            return anxGenericResponse;
        }
        catch (ANXException e) {
            throw this.handleError(e);
        }
        catch (HttpStatusIOException e) {
            throw this.handleHttpError(e);
        }
    }

    public ANXGenericResponse placeANXLimitOrder(CurrencyPair currencyPair, String type, BigDecimal amount, BigDecimal price) throws IOException {
        try {
            ANXGenericResponse anxGenericResponse = this.anxV2.placeOrder(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), currencyPair.base.getCurrencyCode(), currencyPair.counter.getCurrencyCode(), type, amount, price);
            return anxGenericResponse;
        }
        catch (ANXException e) {
            throw this.handleError(e);
        }
        catch (HttpStatusIOException e) {
            throw this.handleHttpError(e);
        }
    }

    public ANXGenericResponse cancelANXOrder(String orderId, String baseCurrency, String counterCurrency) throws IOException {
        try {
            ANXGenericResponse anxGenericResponse = this.anxV2.cancelOrder(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), orderId, baseCurrency, counterCurrency);
            return anxGenericResponse;
        }
        catch (ANXException e) {
            throw this.handleError(e);
        }
        catch (HttpStatusIOException e) {
            throw this.handleHttpError(e);
        }
    }

    public ANXTradeResultWrapper getExecutedANXTrades(Long from, Long to) throws IOException {
        try {
            ANXTradeResultWrapper anxTradeResultWrapper = this.anxV2.getExecutedTrades(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), from, to);
            return anxTradeResultWrapper;
        }
        catch (ANXException e) {
            throw this.handleError(e);
        }
        catch (HttpStatusIOException e) {
            throw this.handleHttpError(e);
        }
    }

    public ANXOrderResultWrapper getANXOrderResult(String orderId, String type, String baseCurrency, String counterCurrency) throws IOException {
        try {
            ANXOrderResultWrapper anxOrderResultWrapper = this.anxV2.getOrderResult(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), baseCurrency, counterCurrency, orderId, type);
            return anxOrderResultWrapper;
        }
        catch (ANXException e) {
            throw this.handleError(e);
        }
        catch (HttpStatusIOException e) {
            throw this.handleHttpError(e);
        }
    }
}

