/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.anx.v2.service;

import java.io.IOException;
import javax.crypto.Mac;
import net.iharder.Base64;
import org.knowm.xchange.service.BaseParamsDigest;
import si.mazi.rescu.RestInvocation;

public class ANXV2Digest
extends BaseParamsDigest {
    private ANXV2Digest(byte[] secretKeyBase64) {
        super(secretKeyBase64, "HmacSHA512");
    }

    public static ANXV2Digest createInstance(String secretKeyBase64) {
        try {
            if (secretKeyBase64 != null) {
                return new ANXV2Digest(Base64.decode((byte[])secretKeyBase64.getBytes()));
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not decode Base 64 string", e);
        }
        return null;
    }

    public String digestParams(RestInvocation restInvocation) {
        Mac mac = this.getMac();
        mac.update(restInvocation.getMethodPath().getBytes());
        mac.update(new byte[]{0});
        mac.update(restInvocation.getRequestBody().getBytes());
        return Base64.encodeBytes((byte[])mac.doFinal()).trim();
    }
}

