/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bittrex.v1.service;

import java.io.IOException;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bittrex.v1.BittrexUtils;
import org.knowm.xchange.bittrex.v1.dto.trade.BittrexCancelOrderResponse;
import org.knowm.xchange.bittrex.v1.dto.trade.BittrexOpenOrder;
import org.knowm.xchange.bittrex.v1.dto.trade.BittrexOpenOrdersResponse;
import org.knowm.xchange.bittrex.v1.dto.trade.BittrexTradeHistoryResponse;
import org.knowm.xchange.bittrex.v1.dto.trade.BittrexTradeResponse;
import org.knowm.xchange.bittrex.v1.dto.trade.BittrexUserTrade;
import org.knowm.xchange.bittrex.v1.service.BittrexBaseService;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;
import si.mazi.rescu.SynchronizedValueFactory;

public class BittrexTradeServiceRaw
extends BittrexBaseService {
    public BittrexTradeServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public String placeBittrexMarketOrder(MarketOrder marketOrder) throws IOException {
        String pair = BittrexUtils.toPairString(marketOrder.getCurrencyPair());
        if (marketOrder.getType() == Order.OrderType.BID) {
            BittrexTradeResponse response = this.bittrexAuthenticated.buymarket(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), pair, marketOrder.getTradableAmount().toPlainString());
            if (response.getSuccess().booleanValue()) {
                return response.getResult().getUuid();
            }
            throw new ExchangeException(response.getMessage());
        }
        BittrexTradeResponse response = this.bittrexAuthenticated.sellmarket(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), pair, marketOrder.getTradableAmount().toPlainString());
        if (response.getSuccess().booleanValue()) {
            return response.getResult().getUuid();
        }
        throw new ExchangeException(response.getMessage());
    }

    public String placeBittrexLimitOrder(LimitOrder limitOrder) throws IOException {
        String pair = BittrexUtils.toPairString(limitOrder.getCurrencyPair());
        if (limitOrder.getType() == Order.OrderType.BID) {
            BittrexTradeResponse response = this.bittrexAuthenticated.buylimit(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), pair, limitOrder.getTradableAmount().toPlainString(), limitOrder.getLimitPrice().toPlainString());
            if (response.getSuccess().booleanValue()) {
                return response.getResult().getUuid();
            }
            throw new ExchangeException(response.getMessage());
        }
        BittrexTradeResponse response = this.bittrexAuthenticated.selllimit(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), pair, limitOrder.getTradableAmount().toPlainString(), limitOrder.getLimitPrice().toPlainString());
        if (response.getSuccess().booleanValue()) {
            return response.getResult().getUuid();
        }
        throw new ExchangeException(response.getMessage());
    }

    public boolean cancelBittrexLimitOrder(String uuid) throws IOException {
        BittrexCancelOrderResponse response = this.bittrexAuthenticated.cancel(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), uuid);
        if (response.getSuccess().booleanValue()) {
            return true;
        }
        throw new ExchangeException(response.getMessage());
    }

    public List<BittrexOpenOrder> getBittrexOpenOrders(OpenOrdersParams params) throws IOException {
        BittrexOpenOrdersResponse response;
        String ccyPair = null;
        if (params != null && params instanceof OpenOrdersParamCurrencyPair) {
            CurrencyPair currencyPair = ((OpenOrdersParamCurrencyPair)params).getCurrencyPair();
            ccyPair = BittrexUtils.toPairString(currencyPair);
        }
        if ((response = this.bittrexAuthenticated.openorders(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), ccyPair)).getSuccess().booleanValue()) {
            return response.getBittrexOpenOrders();
        }
        throw new ExchangeException(response.getMessage());
    }

    public List<BittrexUserTrade> getBittrexTradeHistory(CurrencyPair currencyPair) throws IOException {
        BittrexTradeHistoryResponse response;
        String ccyPair = null;
        if (currencyPair != null) {
            ccyPair = BittrexUtils.toPairString(currencyPair);
        }
        if ((response = this.bittrexAuthenticated.getorderhistory(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), ccyPair)).getSuccess().booleanValue()) {
            return response.getResult();
        }
        throw new ExchangeException(response.getMessage());
    }
}

