/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.ccex;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import org.knowm.xchange.ccex.CCEXUtils;
import org.knowm.xchange.ccex.dto.account.CCEXBalance;
import org.knowm.xchange.ccex.dto.marketdata.CCEXBuySellData;
import org.knowm.xchange.ccex.dto.marketdata.CCEXGetorderbook;
import org.knowm.xchange.ccex.dto.marketdata.CCEXMarket;
import org.knowm.xchange.ccex.dto.marketdata.CCEXTrade;
import org.knowm.xchange.ccex.dto.marketdata.CCEXTrades;
import org.knowm.xchange.ccex.dto.ticker.CCEXPriceResponse;
import org.knowm.xchange.ccex.dto.trade.CCEXOpenorder;
import org.knowm.xchange.ccex.dto.trade.CCEXOrderhistory;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.meta.CurrencyPairMetaData;
import org.knowm.xchange.dto.meta.ExchangeMetaData;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.UserTrade;

public class CCEXAdapters {
    private CCEXAdapters() {
    }

    public static Trades adaptTrades(CCEXTrades cCEXTrades, CurrencyPair currencyPair) {
        ArrayList<Trade> trades = new ArrayList<Trade>();
        List<CCEXTrade> cCEXTradestmp = cCEXTrades.getResult();
        for (CCEXTrade cCEXTrade : cCEXTradestmp) {
            trades.add(CCEXAdapters.adaptCCEXPublicTrade(cCEXTrade, currencyPair));
        }
        return new Trades(trades, Trades.TradeSortType.SortByTimestamp);
    }

    public static Trade adaptCCEXPublicTrade(CCEXTrade cCEXTrade, CurrencyPair currencyPair) {
        Order.OrderType type = cCEXTrade.getOrderType().equalsIgnoreCase("BUY") ? Order.OrderType.BID : Order.OrderType.ASK;
        Date timestamp = CCEXAdapters.stringToDate(cCEXTrade.getTimestamp());
        Trade trade = new Trade(type, cCEXTrade.getQuantity(), currencyPair, cCEXTrade.getPrice(), timestamp, cCEXTrade.getId());
        return trade;
    }

    public static OrderBook adaptOrderBook(CCEXGetorderbook ccexOrderBook, CurrencyPair currencyPair) {
        List<LimitOrder> asks = CCEXAdapters.createOrders(currencyPair, Order.OrderType.ASK, ccexOrderBook.getAsks());
        List<LimitOrder> bids = CCEXAdapters.createOrders(currencyPair, Order.OrderType.BID, ccexOrderBook.getBids());
        Date date = new Date();
        return new OrderBook(date, asks, bids);
    }

    public static List<LimitOrder> createOrders(CurrencyPair currencyPair, Order.OrderType orderType, List<CCEXBuySellData> orders) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        if (orders == null) {
            return new ArrayList<LimitOrder>();
        }
        for (CCEXBuySellData ask : orders) {
            limitOrders.add(CCEXAdapters.createOrder(currencyPair, ask, orderType));
        }
        return limitOrders;
    }

    public static LimitOrder createOrder(CurrencyPair currencyPair, CCEXBuySellData priceAndAmount, Order.OrderType orderType) {
        return new LimitOrder(orderType, priceAndAmount.getQuantity(), currencyPair, "", null, priceAndAmount.getRate());
    }

    public static CurrencyPair adaptCurrencyPair(CCEXMarket product) {
        return new CurrencyPair(product.getBaseCurrency(), product.getMarketCurrency());
    }

    public static ExchangeMetaData adaptToExchangeMetaData(ExchangeMetaData exchangeMetaData, List<CCEXMarket> products) {
        HashMap<CurrencyPair, CurrencyPairMetaData> currencyPairs = new HashMap<CurrencyPair, CurrencyPairMetaData>();
        HashMap<Currency, Object> currencies = new HashMap<Currency, Object>();
        for (CCEXMarket product : products) {
            BigDecimal minSize = product.getMinTradeSize();
            CurrencyPairMetaData cpmd = new CurrencyPairMetaData(null, minSize, null, Integer.valueOf(0));
            CurrencyPair pair = CCEXAdapters.adaptCurrencyPair(product);
            currencyPairs.put(pair, cpmd);
            currencies.put(pair.base, null);
            currencies.put(pair.counter, null);
        }
        return new ExchangeMetaData(currencyPairs, currencies, null, null, Boolean.valueOf(true));
    }

    public static CurrencyPair adaptCurrencyPair(String pair) {
        String[] currencies = pair.toUpperCase().split("-");
        return new CurrencyPair(currencies[0].toUpperCase(), currencies[1].toUpperCase());
    }

    public static Date stringToDate(String dateString) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            return sdf.parse(dateString);
        }
        catch (ParseException e) {
            return new Date(0L);
        }
    }

    public static Wallet adaptWallet(List<CCEXBalance> balances) {
        ArrayList<Balance> wallets = new ArrayList<Balance>(balances.size());
        for (CCEXBalance balance : balances) {
            wallets.add(new Balance(Currency.getInstance((String)balance.getCurrency().toUpperCase()), balance.getBalance(), balance.getAvailable(), balance.getBalance().subtract(balance.getAvailable()).subtract(balance.getPending()), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, balance.getPending()));
        }
        return new Wallet(wallets);
    }

    public static List<LimitOrder> adaptOpenOrders(List<CCEXOpenorder> cCexOpenOrders) {
        ArrayList<LimitOrder> openOrders = new ArrayList<LimitOrder>();
        for (CCEXOpenorder order : cCexOpenOrders) {
            openOrders.add(CCEXAdapters.adaptOpenOrder(order));
        }
        return openOrders;
    }

    public static LimitOrder adaptOpenOrder(CCEXOpenorder cCEXOpenOrder) {
        Order.OrderType type = cCEXOpenOrder.getOrderType().equalsIgnoreCase("LIMIT_SELL") ? Order.OrderType.ASK : Order.OrderType.BID;
        String[] currencies = cCEXOpenOrder.getExchange().split("-");
        CurrencyPair pair = new CurrencyPair(currencies[1], currencies[0]);
        return new LimitOrder(type, cCEXOpenOrder.getQuantityRemaining(), pair, cCEXOpenOrder.getOrderUuid(), null, cCEXOpenOrder.getLimit());
    }

    public static List<UserTrade> adaptUserTrades(List<CCEXOrderhistory> cCEXOrderhistory) {
        ArrayList<UserTrade> trades = new ArrayList<UserTrade>();
        for (CCEXOrderhistory cCEXTrade : cCEXOrderhistory) {
            trades.add(CCEXAdapters.adaptUserTrade(cCEXTrade));
        }
        return trades;
    }

    public static UserTrade adaptUserTrade(CCEXOrderhistory trade) {
        String[] currencies = trade.getExchange().split("-");
        CurrencyPair currencyPair = new CurrencyPair(currencies[1], currencies[0]);
        Order.OrderType orderType = trade.getOrderType().equalsIgnoreCase("LIMIT_BUY") ? Order.OrderType.BID : Order.OrderType.ASK;
        BigDecimal amount = trade.getQuantity().subtract(trade.getQuantityRemaining());
        Date date = CCEXUtils.toDate(trade.getTimeStamp());
        String orderId = String.valueOf(trade.getOrderUuid());
        BigDecimal price = trade.getPricePerUnit();
        if (price == null) {
            price = trade.getLimit();
        }
        return new UserTrade(orderType, amount, currencyPair, price, date, orderId, orderId, trade.getCommission(), currencyPair.counter);
    }

    public static Ticker adaptTicker(CCEXPriceResponse cCEXTicker, CurrencyPair currencyPair) {
        BigDecimal last = cCEXTicker.getLastbuy();
        BigDecimal bid = cCEXTicker.getBuy();
        BigDecimal ask = cCEXTicker.getSell();
        BigDecimal high = cCEXTicker.getHigh();
        BigDecimal low = cCEXTicker.getLow();
        BigDecimal volume = cCEXTicker.getBuysupport();
        Date timestamp = new Date(cCEXTicker.getUpdated());
        return new Ticker.Builder().currencyPair(currencyPair).last(last).bid(bid).ask(ask).high(high).low(low).volume(volume).timestamp(timestamp).build();
    }
}

