/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.ccex.service;

import java.io.IOException;
import java.util.Collection;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ccex.CCEXAdapters;
import org.knowm.xchange.ccex.service.CCEXTradeServiceRaw;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsZero;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;

public class CCEXTradeService
extends CCEXTradeServiceRaw
implements TradeService {
    public CCEXTradeService(Exchange exchange) {
        super(exchange);
    }

    public OpenOrders getOpenOrders() throws IOException {
        return this.getOpenOrders(this.createOpenOrdersParams());
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        return new OpenOrders(CCEXAdapters.adaptOpenOrders(this.getCCEXOpenOrders()));
    }

    public String placeMarketOrder(MarketOrder marketOrder) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        throw new NotAvailableFromExchangeException();
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        String id = this.placeCCEXLimitOrder(limitOrder);
        return id;
    }

    public boolean cancelOrder(String orderId) throws IOException {
        return this.cancelCCEXLimitOrder(orderId);
    }

    public boolean cancelOrder(CancelOrderParams orderParams) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        if (orderParams instanceof CancelOrderByIdParams) {
            this.cancelOrder(((CancelOrderByIdParams)orderParams).orderId);
        }
        return false;
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws IOException {
        return new UserTrades(CCEXAdapters.adaptUserTrades(this.getCCEXTradeHistory()), Trades.TradeSortType.SortByTimestamp);
    }

    public TradeHistoryParams createTradeHistoryParams() {
        return TradeHistoryParamsZero.PARAMS_ZERO;
    }

    public OpenOrdersParams createOpenOrdersParams() {
        return null;
    }

    public Collection<Order> getOrder(String ... orderIds) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        throw new NotYetImplementedForExchangeException();
    }
}

