/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.meta.ExchangeMetaData;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.service.BaseExchangeService;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.marketdata.MarketDataService;
import org.knowm.xchange.service.trade.TradeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseExchange
implements Exchange {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ExchangeSpecification exchangeSpecification;
    protected ExchangeMetaData exchangeMetaData;
    protected MarketDataService marketDataService;
    protected TradeService tradeService;
    protected AccountService accountService;

    protected abstract void initServices();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applySpecification(ExchangeSpecification exchangeSpecification) {
        block23: {
            InputStream is;
            block24: {
                ExchangeSpecification defaultSpecification = this.getDefaultExchangeSpecification();
                if (exchangeSpecification == null) {
                    this.exchangeSpecification = defaultSpecification;
                } else {
                    if (exchangeSpecification.getExchangeName() == null) {
                        exchangeSpecification.setExchangeName(defaultSpecification.getExchangeName());
                    }
                    if (exchangeSpecification.getExchangeDescription() == null) {
                        exchangeSpecification.setExchangeDescription(defaultSpecification.getExchangeDescription());
                    }
                    if (exchangeSpecification.getSslUri() == null) {
                        exchangeSpecification.setSslUri(defaultSpecification.getSslUri());
                    }
                    if (exchangeSpecification.getHost() == null) {
                        exchangeSpecification.setHost(defaultSpecification.getHost());
                    }
                    if (exchangeSpecification.getPlainTextUri() == null) {
                        exchangeSpecification.setPlainTextUri(defaultSpecification.getPlainTextUri());
                    }
                    if (exchangeSpecification.getExchangeSpecificParameters() == null) {
                        exchangeSpecification.setExchangeSpecificParameters(defaultSpecification.getExchangeSpecificParameters());
                    } else {
                        for (Map.Entry<String, Object> entry : defaultSpecification.getExchangeSpecificParameters().entrySet()) {
                            if (exchangeSpecification.getExchangeSpecificParametersItem(entry.getKey()) != null) continue;
                            exchangeSpecification.setExchangeSpecificParametersItem(entry.getKey(), entry.getValue());
                        }
                    }
                    this.exchangeSpecification = exchangeSpecification;
                }
                if (this.exchangeSpecification.getMetaDataJsonFileOverride() == null) break block24;
                is = null;
                try {
                    is = new FileInputStream(this.exchangeSpecification.getMetaDataJsonFileOverride());
                    this.loadExchangeMetaData(is);
                }
                catch (FileNotFoundException e) {
                    try {
                        this.logger.warn("An exception occured while loading the metadata file from the classpath. This is just a warning and can be ignored, but it may lead to unexpected results, so it's better to address it.", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)is);
                    break block23;
                }
                IOUtils.closeQuietly((InputStream)is);
                break block23;
            }
            if (this.exchangeSpecification.getExchangeName() != null) {
                is = null;
                try {
                    is = BaseExchangeService.class.getClassLoader().getResourceAsStream(this.getMetaDataFileName(exchangeSpecification) + ".json");
                    this.loadExchangeMetaData(is);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
            } else {
                this.logger.warn("No \"exchange name\" found in the ExchangeSpecification. The name is used to load the meta data file from the classpath and may lead to unexpected results.");
            }
        }
        this.initServices();
        if (this.exchangeSpecification.isShouldLoadRemoteMetaData()) {
            try {
                this.logger.info("Calling Remote Init...");
                this.remoteInit();
            }
            catch (ExchangeException e) {
                throw e;
            }
            catch (IOException e) {
                throw new ExchangeException(e);
            }
        }
    }

    @Override
    public void remoteInit() throws IOException, ExchangeException {
        this.logger.info("No remote initialization implemented for {}. The exchange meta data for this exchange is loaded from a json file containing hard-coded exchange meta-data. This may or may not be OK for you, and you should understand exactly how this works. Each exchange can either 1) rely on the hard-coded json file that comes packaged with XChange's jar, 2) provide your own override json file, 3) properly implement the `remoteInit()` method for the exchange (please submit a pull request so the whole community can benefit) or 4) a combination of hard-coded JSON and remote API calls. For more info see: https://github.com/timmolter/XChange/wiki/Design-Notes#exchange-metadata", (Object)this.exchangeSpecification.getExchangeName());
    }

    protected void loadExchangeMetaData(InputStream is) {
        this.exchangeMetaData = this.loadMetaData(is, ExchangeMetaData.class);
    }

    protected <T> T loadMetaData(InputStream is, Class<T> type) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            Object result = mapper.readValue(is, type);
            this.logger.debug(result.toString());
            return (T)result;
        }
        catch (Exception e) {
            this.logger.warn("An exception occured while loading the metadata file from the file system. This is just a warning and can be ignored, but it may lead to unexpected results, so it's better to address it.", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<CurrencyPair> getExchangeSymbols() {
        return new ArrayList<CurrencyPair>(this.getExchangeMetaData().getCurrencyPairs().keySet());
    }

    public String getMetaDataFileName(ExchangeSpecification exchangeSpecification) {
        return exchangeSpecification.getExchangeName().toLowerCase().replace(" ", "").replace("-", "").replace(".", "");
    }

    @Override
    public ExchangeSpecification getExchangeSpecification() {
        return this.exchangeSpecification;
    }

    @Override
    public ExchangeMetaData getExchangeMetaData() {
        return this.exchangeMetaData;
    }

    @Override
    public MarketDataService getMarketDataService() {
        return this.marketDataService;
    }

    @Override
    public TradeService getTradeService() {
        return this.tradeService;
    }

    @Override
    public AccountService getAccountService() {
        return this.accountService;
    }

    public String toString() {
        String name = this.exchangeSpecification != null ? this.exchangeSpecification.getExchangeName() : this.getClass().getName();
        return name + "#" + this.hashCode();
    }
}

