/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange;

import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.utils.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ExchangeFactory {
    INSTANCE;

    private final Logger log = LoggerFactory.getLogger(ExchangeFactory.class);

    public Exchange createExchangeWithoutSpecification(String exchangeClassName) {
        Assert.notNull(exchangeClassName, "exchangeClassName cannot be null");
        this.log.debug("Creating default exchange from class name");
        try {
            Class<?> exchangeProviderClass = Class.forName(exchangeClassName);
            if (Exchange.class.isAssignableFrom(exchangeProviderClass)) {
                Exchange exchange = (Exchange)exchangeProviderClass.newInstance();
                return exchange;
            }
            throw new ExchangeException("Class '" + exchangeClassName + "' does not implement Exchange");
        }
        catch (ClassNotFoundException e) {
            throw new ExchangeException("Problem creating Exchange (class not found)", e);
        }
        catch (InstantiationException e) {
            throw new ExchangeException("Problem creating Exchange (instantiation)", e);
        }
        catch (IllegalAccessException e) {
            throw new ExchangeException("Problem creating Exchange (illegal access)", e);
        }
    }

    public Exchange createExchange(String exchangeClassName, String userName, String password, String apiKey, String secretKey) {
        Assert.notNull(exchangeClassName, "exchangeClassName cannot be null");
        this.log.debug("Creating default exchange from class name");
        Exchange exchange = this.createExchangeWithoutSpecification(exchangeClassName);
        ExchangeSpecification specification = exchange.getDefaultExchangeSpecification();
        if (userName != null) {
            specification.setUserName(userName);
        }
        if (password != null) {
            specification.setPassword(password);
        }
        if (apiKey != null) {
            specification.setApiKey(apiKey);
        }
        if (secretKey != null) {
            specification.setSecretKey(secretKey);
        }
        exchange.applySpecification(specification);
        return exchange;
    }

    public Exchange createExchangeWithUserNameAndPassword(String exchangeClassName, String userName, String password) {
        return this.createExchange(exchangeClassName, userName, password, null, null);
    }

    public Exchange createExchangeWithApiKeys(String exchangeClassName, String apiKey, String secretKey) {
        return this.createExchange(exchangeClassName, null, null, apiKey, secretKey);
    }

    public Exchange createExchange(String exchangeClassName) {
        return this.createExchange(exchangeClassName, null, null, null, null);
    }

    public Exchange createExchange(ExchangeSpecification exchangeSpecification) {
        Assert.notNull(exchangeSpecification, "exchangeSpecfication cannot be null");
        this.log.debug("Creating exchange from specification");
        String exchangeClassName = exchangeSpecification.getExchangeClassName();
        try {
            Class<?> exchangeProviderClass = Class.forName(exchangeClassName);
            if (Exchange.class.isAssignableFrom(exchangeProviderClass)) {
                Exchange exchange = (Exchange)exchangeProviderClass.newInstance();
                exchange.applySpecification(exchangeSpecification);
                return exchange;
            }
            throw new ExchangeException("Class '" + exchangeClassName + "' does not implement Exchange");
        }
        catch (ClassNotFoundException e) {
            throw new ExchangeException("Problem starting exchange provider (class not found)", e);
        }
        catch (InstantiationException e) {
            throw new ExchangeException("Problem starting exchange provider (instantiation)", e);
        }
        catch (IllegalAccessException e) {
            throw new ExchangeException("Problem starting exchange provider (illegal access)", e);
        }
    }
}

