/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.currency;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class Currency
implements Comparable<Currency> {
    private static final Map<String, Currency> currencies = new HashMap<String, Currency>();
    public static final Currency AED = Currency.createCurrency("AED", "United Arab Emirates Dirham", null, new String[0]);
    public static final Currency AFN = Currency.createCurrency("AFN", "Afghan Afghani", null, new String[0]);
    public static final Currency ALL = Currency.createCurrency("ALL", "Albanian Lek", null, new String[0]);
    public static final Currency AMD = Currency.createCurrency("AMD", "Armenian Dram", null, new String[0]);
    public static final Currency ANC = Currency.createCurrency("ANC", "Anoncoin", null, new String[0]);
    public static final Currency ANG = Currency.createCurrency("ANG", "Netherlands Antillean Guilder", null, new String[0]);
    public static final Currency AOA = Currency.createCurrency("AOA", "Angolan Kwanza", null, new String[0]);
    public static final Currency ARS = Currency.createCurrency("ARS", "Argentine Peso", null, new String[0]);
    public static final Currency AUD = Currency.createCurrency("AUD", "Australian Dollar", null, new String[0]);
    public static final Currency AUR = Currency.createCurrency("AUR", "Auroracoin", null, new String[0]);
    public static final Currency AWG = Currency.createCurrency("AWG", "Aruban Florin", null, new String[0]);
    public static final Currency AZN = Currency.createCurrency("AZN", "Azerbaijani Manat", null, new String[0]);
    public static final Currency BAM = Currency.createCurrency("BAM", "Bosnia-Herzegovina Convertible Mark", null, new String[0]);
    public static final Currency BBD = Currency.createCurrency("BBD", "Barbadian Dollar", null, new String[0]);
    public static final Currency BC = Currency.createCurrency("BC", "BlackCoin", null, "BLK");
    public static final Currency BLK = Currency.getInstance("BLK");
    public static final Currency BDT = Currency.createCurrency("BDT", "Bangladeshi Taka", null, new String[0]);
    public static final Currency BGC = Currency.createCurrency("BGC", "Aten 'Black Gold' Coin", null, new String[0]);
    public static final Currency BGN = Currency.createCurrency("BGN", "Bulgarian Lev", null, new String[0]);
    public static final Currency BHD = Currency.createCurrency("BHD", "Bahraini Dinar", null, new String[0]);
    public static final Currency BIF = Currency.createCurrency("BIF", "Burundian Franc", null, new String[0]);
    public static final Currency BMD = Currency.createCurrency("BMD", "Bermudan Dollar", null, new String[0]);
    public static final Currency BND = Currency.createCurrency("BND", "Brunei Dollar", null, new String[0]);
    public static final Currency BOB = Currency.createCurrency("BOB", "Bolivian Boliviano", null, new String[0]);
    public static final Currency BRL = Currency.createCurrency("BRL", "Brazilian Real", "R$", new String[0]);
    public static final Currency BSD = Currency.createCurrency("BSD", "Bahamian Dollar", null, new String[0]);
    public static final Currency BTC = Currency.createCurrency("BTC", "Bitcoin", null, "XBT");
    public static final Currency XBT = Currency.getInstance("XBT");
    public static final Currency BTN = Currency.createCurrency("BTN", "Bhutanese Ngultrum", null, new String[0]);
    public static final Currency BWP = Currency.createCurrency("BWP", "Botswanan Pula", null, new String[0]);
    public static final Currency BYR = Currency.createCurrency("BYR", "Belarusian Ruble", null, new String[0]);
    public static final Currency BZD = Currency.createCurrency("BZD", "Belize Dollar", null, new String[0]);
    public static final Currency CAD = Currency.createCurrency("CAD", "Canadian Dollar", null, new String[0]);
    public static final Currency CDF = Currency.createCurrency("CDF", "Congolese Franc", null, new String[0]);
    public static final Currency CHF = Currency.createCurrency("CHF", "Swiss Franc", null, new String[0]);
    public static final Currency CLF = Currency.createCurrency("CLF", "Chilean Unit of Account (UF)", null, new String[0]);
    public static final Currency CLP = Currency.createCurrency("CLP", "Chilean Peso", null, new String[0]);
    public static final Currency CNC = Currency.createCurrency("CNC", "Chinacoin", null, new String[0]);
    public static final Currency CNY = Currency.createCurrency("CNY", "Chinese Yuan", null, new String[0]);
    public static final Currency COP = Currency.createCurrency("COP", "Colombian Peso", null, new String[0]);
    public static final Currency CRC = Currency.createCurrency("CRC", "Costa Rican Col\u00f3n", null, new String[0]);
    public static final Currency CUP = Currency.createCurrency("CUP", "Cuban Peso", null, new String[0]);
    public static final Currency CVE = Currency.createCurrency("CVE", "Cape Verdean Escudo", null, new String[0]);
    public static final Currency CZK = Currency.createCurrency("CZK", "Czech Republic Koruna", null, new String[0]);
    public static final Currency DGB = Currency.createCurrency("DGB", "DigiByte", null, new String[0]);
    public static final Currency DJF = Currency.createCurrency("DJF", "Djiboutian Franc", null, new String[0]);
    public static final Currency DKK = Currency.createCurrency("DKK", "Danish Krone", null, new String[0]);
    public static final Currency DOGE = Currency.createCurrency("DOGE", "Dogecoin", null, "XDC", "XDG");
    public static final Currency XDC = Currency.getInstance("XDC");
    public static final Currency XDG = Currency.getInstance("XDG");
    public static final Currency DOP = Currency.createCurrency("DOP", "Dominican Peso", null, new String[0]);
    public static final Currency DGC = Currency.createCurrency("DGC", "Digitalcoin", null, new String[0]);
    public static final Currency DVC = Currency.createCurrency("DVC", "Devcoin", null, new String[0]);
    public static final Currency DRK = Currency.createCurrency("DRK", "Darkcoin", null, new String[0]);
    public static final Currency DZD = Currency.createCurrency("DZD", "Algerian Dinar", null, new String[0]);
    public static final Currency EEK = Currency.createCurrency("EEK", "Estonian Kroon", null, new String[0]);
    public static final Currency EGD = Currency.createCurrency("EGD", "egoldcoin", null, new String[0]);
    public static final Currency EGP = Currency.createCurrency("EGP", "Egyptian Pound", null, new String[0]);
    public static final Currency ETB = Currency.createCurrency("ETB", "Ethiopian Birr", null, new String[0]);
    public static final Currency ETH = Currency.createCurrency("ETH", "Ether", null, new String[0]);
    public static final Currency EUR = Currency.createCurrency("EUR", "Euro", null, new String[0]);
    public static final Currency FJD = Currency.createCurrency("FJD", "Fijian Dollar", null, new String[0]);
    public static final Currency FKP = Currency.createCurrency("FKP", "Falkland Islands Pound", null, new String[0]);
    public static final Currency FTC = Currency.createCurrency("FTC", "Feathercoin", null, new String[0]);
    public static final Currency GBP = Currency.createCurrency("GBP", "British Pound Sterling", null, new String[0]);
    public static final Currency GEL = Currency.createCurrency("GEL", "Georgian Lari", null, new String[0]);
    public static final Currency GHS = Currency.createCurrency("GHS", "Ghanaian Cedi", null, new String[0]);
    public static final Currency GHs = Currency.createCurrency("GHS", "Gigahashes per second", null, new String[0]);
    public static final Currency GIP = Currency.createCurrency("GIP", "Gibraltar Pound", null, new String[0]);
    public static final Currency GMD = Currency.createCurrency("GMD", "Gambian Dalasi", null, new String[0]);
    public static final Currency GNF = Currency.createCurrency("GNF", "Guinean Franc", null, new String[0]);
    public static final Currency GTQ = Currency.createCurrency("GTQ", "Guatemalan Quetzal", null, new String[0]);
    public static final Currency GYD = Currency.createCurrency("GYD", "Guyanaese Dollar", null, new String[0]);
    public static final Currency HKD = Currency.createCurrency("HKD", "Hong Kong Dollar", null, new String[0]);
    public static final Currency HNL = Currency.createCurrency("HNL", "Honduran Lempira", null, new String[0]);
    public static final Currency HRK = Currency.createCurrency("HRK", "Croatian Kuna", null, new String[0]);
    public static final Currency HTG = Currency.createCurrency("HTG", "Haitian Gourde", null, new String[0]);
    public static final Currency HUF = Currency.createCurrency("HUF", "Hungarian Forint", null, new String[0]);
    public static final Currency IDR = Currency.createCurrency("IDR", "Indonesian Rupiah", null, new String[0]);
    public static final Currency ILS = Currency.createCurrency("ILS", "Israeli New Sheqel", null, new String[0]);
    public static final Currency INR = Currency.createCurrency("INR", "Indian Rupee", null, new String[0]);
    public static final Currency IOC = Currency.createCurrency("IOC", "I/OCoin", null, new String[0]);
    public static final Currency IQD = Currency.createCurrency("IQD", "Iraqi Dinar", null, new String[0]);
    public static final Currency IRR = Currency.createCurrency("IRR", "Iranian Rial", null, new String[0]);
    public static final Currency ISK = Currency.createCurrency("ISK", "Icelandic Kr\u00f3na", null, new String[0]);
    public static final Currency IXC = Currency.createCurrency("IXC", "iXcoin", null, new String[0]);
    public static final Currency JEP = Currency.createCurrency("JEP", "Jersey Pound", null, new String[0]);
    public static final Currency JMD = Currency.createCurrency("JMD", "Jamaican Dollar", null, new String[0]);
    public static final Currency JOD = Currency.createCurrency("JOD", "Jordanian Dinar", null, new String[0]);
    public static final Currency JPY = Currency.createCurrency("JPY", "Japanese Yen", null, new String[0]);
    public static final Currency KES = Currency.createCurrency("KES", "Kenyan Shilling", null, new String[0]);
    public static final Currency KGS = Currency.createCurrency("KGS", "Kyrgystani Som", null, new String[0]);
    public static final Currency KHR = Currency.createCurrency("KHR", "Cambodian Riel", null, new String[0]);
    public static final Currency KMF = Currency.createCurrency("KMF", "Comorian Franc", null, new String[0]);
    public static final Currency KPW = Currency.createCurrency("KPW", "North Korean Won", null, new String[0]);
    public static final Currency KRW = Currency.createCurrency("KRW", "South Korean Won", null, new String[0]);
    public static final Currency KWD = Currency.createCurrency("KWD", "Kuwaiti Dinar", null, new String[0]);
    public static final Currency KYD = Currency.createCurrency("KYD", "Cayman Islands Dollar", null, new String[0]);
    public static final Currency KZT = Currency.createCurrency("KZT", "Kazakhstani Tenge", null, new String[0]);
    public static final Currency LAK = Currency.createCurrency("LAK", "Laotian Kip", null, new String[0]);
    public static final Currency LBP = Currency.createCurrency("LBP", "Lebanese Pound", null, new String[0]);
    public static final Currency LKR = Currency.createCurrency("LKR", "Sri Lankan Rupee", null, new String[0]);
    public static final Currency LRD = Currency.createCurrency("LRD", "Liberian Dollar", null, new String[0]);
    public static final Currency LSL = Currency.createCurrency("LSL", "Lesotho Loti", null, new String[0]);
    public static final Currency LTC = Currency.createCurrency("LTC", "Litecoin", "XLT", new String[0]);
    public static final Currency XLT = Currency.getInstance("XLT");
    public static final Currency LTL = Currency.createCurrency("LTL", "Lithuanian Litas", null, new String[0]);
    public static final Currency LVL = Currency.createCurrency("LVL", "Latvian Lats", null, new String[0]);
    public static final Currency LYD = Currency.createCurrency("LYD", "Libyan Dinar", null, new String[0]);
    public static final Currency MAD = Currency.createCurrency("MAD", "Moroccan Dirham", null, new String[0]);
    public static final Currency MDL = Currency.createCurrency("MDL", "Moldovan Leu", null, new String[0]);
    public static final Currency MEC = Currency.createCurrency("MEC", "MegaCoin", null, new String[0]);
    public static final Currency MGA = Currency.createCurrency("MGA", "Malagasy Ariary", null, new String[0]);
    public static final Currency MKD = Currency.createCurrency("MKD", "Macedonian Denar", null, new String[0]);
    public static final Currency MMK = Currency.createCurrency("MMK", "Myanma Kyat", null, new String[0]);
    public static final Currency MNT = Currency.createCurrency("MNT", "Mongolian Tugrik", null, new String[0]);
    public static final Currency MOP = Currency.createCurrency("MOP", "Macanese Pataca", null, new String[0]);
    public static final Currency MRO = Currency.createCurrency("MRO", "Mauritanian Ouguiya", null, new String[0]);
    public static final Currency MSC = Currency.createCurrency("MSC", "Mason Coin", null, new String[0]);
    public static final Currency MUR = Currency.createCurrency("MUR", "Mauritian Rupee", null, new String[0]);
    public static final Currency MVR = Currency.createCurrency("MVR", "Maldivian Rufiyaa", null, new String[0]);
    public static final Currency MWK = Currency.createCurrency("MWK", "Malawian Kwacha", null, new String[0]);
    public static final Currency MXN = Currency.createCurrency("MXN", "Mexican Peso", null, new String[0]);
    public static final Currency MYR = Currency.createCurrency("MYR", "Malaysian Ringgit", null, new String[0]);
    public static final Currency MZN = Currency.createCurrency("MZN", "Mozambican Metical", null, new String[0]);
    public static final Currency NAD = Currency.createCurrency("NAD", "Namibian Dollar", null, new String[0]);
    public static final Currency NGN = Currency.createCurrency("NGN", "Nigerian Naira", null, new String[0]);
    public static final Currency NIO = Currency.createCurrency("NIO", "Nicaraguan C\u00f3rdoba", null, new String[0]);
    public static final Currency NMC = Currency.createCurrency("NMC", "Namecoin", null, new String[0]);
    public static final Currency NOK = Currency.createCurrency("NOK", "Norwegian Krone", null, new String[0]);
    public static final Currency NPR = Currency.createCurrency("NPR", "Nepalese Rupee", null, new String[0]);
    public static final Currency NVC = Currency.createCurrency("NVC", "Novacoin", null, new String[0]);
    public static final Currency NXT = Currency.createCurrency("NXT", "Nextcoin", null, new String[0]);
    public static final Currency NZD = Currency.createCurrency("NZD", "New Zealand Dollar", null, new String[0]);
    public static final Currency OMR = Currency.createCurrency("OMR", "Omani Rial", null, new String[0]);
    public static final Currency PAB = Currency.createCurrency("PAB", "Panamanian Balboa", null, new String[0]);
    public static final Currency PEN = Currency.createCurrency("PEN", "Peruvian Nuevo Sol", null, new String[0]);
    public static final Currency PGK = Currency.createCurrency("PGK", "Papua New Guinean Kina", null, new String[0]);
    public static final Currency PHP = Currency.createCurrency("PHP", "Philippine Peso", null, new String[0]);
    public static final Currency PKR = Currency.createCurrency("PKR", "Pakistani Rupee", null, new String[0]);
    public static final Currency PLN = Currency.createCurrency("PLN", "Polish Zloty", null, new String[0]);
    public static final Currency POT = Currency.createCurrency("POT", "PotCoin", null, new String[0]);
    public static final Currency PPC = Currency.createCurrency("PPC", "Peercoin", null, new String[0]);
    public static final Currency PYG = Currency.createCurrency("PYG", "Paraguayan Guarani", null, new String[0]);
    public static final Currency QAR = Currency.createCurrency("QAR", "Qatari Rial", null, new String[0]);
    public static final Currency QRK = Currency.createCurrency("QRK", "QuarkCoin", null, new String[0]);
    public static final Currency REP = Currency.createCurrency("REP", "Augur", null, new String[0]);
    public static final Currency RON = Currency.createCurrency("RON", "Romanian Leu", null, new String[0]);
    public static final Currency RSD = Currency.createCurrency("RSD", "Serbian Dinar", null, new String[0]);
    public static final Currency RUB = Currency.createCurrency("RUB", "Russian Ruble", null, new String[0]);
    public static final Currency RUR = Currency.createCurrency("RUR", "Old Russian Ruble", null, new String[0]);
    public static final Currency RWF = Currency.createCurrency("RWF", "Rwandan Franc", null, new String[0]);
    public static final Currency SAR = Currency.createCurrency("SAR", "Saudi Riyal", null, new String[0]);
    public static final Currency SBC = Currency.createCurrency("SBC", "Stablecoin", null, new String[0]);
    public static final Currency SBD = Currency.createCurrency("SBD", "Solomon Islands Dollar", null, new String[0]);
    public static final Currency SCR = Currency.createCurrency("SCR", "Seychellois Rupee", null, new String[0]);
    public static final Currency SDG = Currency.createCurrency("SDG", "Sudanese Pound", null, new String[0]);
    public static final Currency SEK = Currency.createCurrency("SEK", "Swedish Krona", null, new String[0]);
    public static final Currency SGD = Currency.createCurrency("SGD", "Singapore Dollar", null, new String[0]);
    public static final Currency SHP = Currency.createCurrency("SHP", "Saint Helena Pound", null, new String[0]);
    public static final Currency SLL = Currency.createCurrency("SLL", "Sierra Leonean Leone", null, new String[0]);
    public static final Currency SOS = Currency.createCurrency("SOS", "Somali Shilling", null, new String[0]);
    public static final Currency SRD = Currency.createCurrency("SRD", "Surinamese Dollar", null, new String[0]);
    public static final Currency START = Currency.createCurrency("START", "startcoin", null, new String[0]);
    public static final Currency STD = Currency.createCurrency("STD", "S\u00e3o Tom\u00e9 and Pr\u00edncipe Dobra", null, new String[0]);
    public static final Currency STR = Currency.createCurrency("STR", "Stellar", null, new String[0]);
    public static final Currency SVC = Currency.createCurrency("SVC", "Salvadoran Col\u00f3n", null, new String[0]);
    public static final Currency SYP = Currency.createCurrency("SYP", "Syrian Pound", null, new String[0]);
    public static final Currency SZL = Currency.createCurrency("SZL", "Swazi Lilangeni", null, new String[0]);
    public static final Currency THB = Currency.createCurrency("THB", "Thai Baht", null, new String[0]);
    public static final Currency TJS = Currency.createCurrency("TJS", "Tajikistani Somoni", null, new String[0]);
    public static final Currency TMT = Currency.createCurrency("TMT", "Turkmenistani Manat", null, new String[0]);
    public static final Currency TND = Currency.createCurrency("TND", "Tunisian Dinar", null, new String[0]);
    public static final Currency TOP = Currency.createCurrency("TOP", "Tongan Pa\u02bbanga", null, new String[0]);
    public static final Currency TRC = Currency.createCurrency("TRC", "Terracoin", null, new String[0]);
    public static final Currency TRY = Currency.createCurrency("TRY", "Turkish Lira", null, new String[0]);
    public static final Currency TTD = Currency.createCurrency("TTD", "Trinidad and Tobago Dollar", null, new String[0]);
    public static final Currency TWD = Currency.createCurrency("TWD", "New Taiwan Dollar", null, new String[0]);
    public static final Currency TZS = Currency.createCurrency("TZS", "Tanzanian Shilling", null, new String[0]);
    public static final Currency UAH = Currency.createCurrency("UAH", "Ukrainian Hryvnia", null, new String[0]);
    public static final Currency UGX = Currency.createCurrency("UGX", "Ugandan Shilling", null, new String[0]);
    public static final Currency USD = Currency.createCurrency("USD", "United States Dollar", null, new String[0]);
    public static final Currency USDT = Currency.createCurrency("USDT", "Tether USD Anchor", null, new String[0]);
    public static final Currency USDE = Currency.createCurrency("USDE", "Unitary Status Dollar eCoin", null, new String[0]);
    public static final Currency UTC = Currency.createCurrency("UTC", "Ultracoin", null, new String[0]);
    public static final Currency UYU = Currency.createCurrency("UYU", "Uruguayan Peso", null, new String[0]);
    public static final Currency UZS = Currency.createCurrency("UZS", "Uzbekistan Som", null, new String[0]);
    public static final Currency VEF = Currency.createCurrency("VEF", "Venezuelan Bol\u00edvar", null, new String[0]);
    public static final Currency VEN = Currency.createCurrency("VEN", "Hub Culture's Ven", null, "XVN");
    public static final Currency XVN = Currency.getInstance("XVN");
    public static final Currency VND = Currency.createCurrency("VND", "Vietnamese Dong", null, new String[0]);
    public static final Currency VUV = Currency.createCurrency("VUV", "Vanuatu Vatu", null, new String[0]);
    public static final Currency WDC = Currency.createCurrency("WDC", "WorldCoin", null, new String[0]);
    public static final Currency WST = Currency.createCurrency("WST", "Samoan Tala", null, new String[0]);
    public static final Currency XAF = Currency.createCurrency("XAF", "CFA Franc BEAC", null, new String[0]);
    public static final Currency XAUR = Currency.createCurrency("XAUR", "Xaurum", null, new String[0]);
    public static final Currency XCD = Currency.createCurrency("XCD", "East Caribbean Dollar", null, new String[0]);
    public static final Currency XDR = Currency.createCurrency("XDR", "Special Drawing Rights", null, new String[0]);
    public static final Currency XMR = Currency.createCurrency("XMR", "Monero", null, new String[0]);
    public static final Currency XOF = Currency.createCurrency("XOF", "CFA Franc BCEAO", null, new String[0]);
    public static final Currency XPF = Currency.createCurrency("XPF", "CFP Franc", null, new String[0]);
    public static final Currency XPM = Currency.createCurrency("XPM", "Primecoin", null, new String[0]);
    public static final Currency XRP = Currency.createCurrency("XRP", "Ripple", null, new String[0]);
    public static final Currency YBC = Currency.createCurrency("YBC", "YbCoin", null, new String[0]);
    public static final Currency YER = Currency.createCurrency("YER", "Yemeni Rial", null, new String[0]);
    public static final Currency ZAR = Currency.createCurrency("ZAR", "South African Rand", null, new String[0]);
    public static final Currency ZMK = Currency.createCurrency("ZMK", "Zambian Kwacha", null, new String[0]);
    public static final Currency ZRC = Currency.createCurrency("ZRC", "ziftrCOIN", null, new String[0]);
    public static final Currency ZWL = Currency.createCurrency("ZWL", "Zimbabwean Dollar", null, new String[0]);
    private final String code;
    private final CurrencyAttributes attributes;

    public static SortedSet<Currency> getAvailableCurrencies() {
        return new TreeSet<Currency>(currencies.values());
    }

    public static SortedSet<String> getAvailableCurrencyCodes() {
        return new TreeSet<String>(currencies.keySet());
    }

    public static Currency getInstance(String currencyCode) {
        Currency currency = Currency.getInstanceNoCreate(currencyCode.toUpperCase());
        if (currency == null) {
            return Currency.createCurrency(currencyCode.toUpperCase(), null, null, new String[0]);
        }
        return currency;
    }

    public static Currency getInstanceNoCreate(String currencyCode) {
        return currencies.get(currencyCode.toUpperCase());
    }

    public Currency(String code) {
        this.code = code;
        this.attributes = Currency.getInstance((String)code).attributes;
    }

    public String getCurrencyCode() {
        return this.code;
    }

    public Currency getCodeCurrency(String code) {
        if (code.equals(this.code)) {
            return this;
        }
        Currency currency = Currency.getInstance(code);
        if (currency.equals(this)) {
            return currency;
        }
        if (!this.attributes.codes.contains(code)) {
            throw new IllegalArgumentException("Code not listed for this currency");
        }
        return new Currency(code, this.attributes);
    }

    public Currency getIso4217Currency() {
        if (this.attributes.isoCode == null) {
            return this;
        }
        return this.getCodeCurrency(this.attributes.isoCode);
    }

    public Currency getCommonlyUsedCurrency() {
        return this.getCodeCurrency(this.attributes.commonCode);
    }

    public Set<String> getCurrencyCodes() {
        return this.attributes.codes;
    }

    public String getSymbol() {
        return this.attributes.unicode;
    }

    public String getDisplayName() {
        return this.attributes.name;
    }

    private static Currency createCurrency(String commonCode, String name, String unicode, String ... alternativeCodes) {
        CurrencyAttributes attributes = new CurrencyAttributes(commonCode, name, unicode, alternativeCodes);
        Currency currency = new Currency(commonCode, attributes);
        for (String code : attributes.codes) {
            if (commonCode.equals(code)) {
                currencies.put(code, currency);
                continue;
            }
            if (currencies.containsKey(code)) continue;
            currencies.put(code, new Currency(code, attributes));
        }
        return currency;
    }

    private Currency(String alternativeCode, CurrencyAttributes attributes) {
        this.code = alternativeCode;
        this.attributes = attributes;
    }

    public String toString() {
        return this.code;
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Currency other = (Currency)obj;
        return this.attributes == other.attributes;
    }

    @Override
    public int compareTo(Currency o) {
        if (this.attributes == o.attributes) {
            return 0;
        }
        int comparison = this.code.compareTo(o.code);
        if (comparison == 0) {
            comparison = this.getDisplayName().compareTo(o.getDisplayName());
        }
        if (comparison == 0) {
            comparison = this.hashCode() - o.hashCode();
        }
        return comparison;
    }

    private static class CurrencyAttributes {
        public final Set<String> codes;
        public final String isoCode;
        public final String commonCode;
        public final String name;
        public final String unicode;

        public CurrencyAttributes(String commonCode, String name, String unicode, String ... alternativeCodes) {
            if (alternativeCodes.length > 0) {
                this.codes = new TreeSet<String>(Arrays.asList(alternativeCodes));
                this.codes.add(commonCode);
            } else {
                this.codes = Collections.singleton(commonCode);
            }
            String possibleIsoProposalCryptoCode = null;
            java.util.Currency javaCurrency = null;
            for (String code : this.codes) {
                if (javaCurrency == null) {
                    try {
                        javaCurrency = java.util.Currency.getInstance(code);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (!code.startsWith("X")) continue;
                possibleIsoProposalCryptoCode = code;
            }
            this.isoCode = javaCurrency != null ? javaCurrency.getCurrencyCode() : possibleIsoProposalCryptoCode;
            this.commonCode = commonCode;
            this.name = name != null ? name : (javaCurrency != null ? javaCurrency.getDisplayName() : commonCode);
            this.unicode = unicode != null ? unicode : (javaCurrency != null ? javaCurrency.getSymbol() : commonCode);
        }
    }
}

