/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto;

import java.math.BigDecimal;
import java.util.Date;
import org.knowm.xchange.dto.Order;

public class LoanOrder {
    private final Order.OrderType type;
    private final String currency;
    private final BigDecimal tradableAmount;
    private final int dayPeriod;
    private final String id;
    private final Date timestamp;

    public LoanOrder(Order.OrderType type, String currency, BigDecimal tradableAmount, int dayPeriod, String id, Date timestamp) {
        this.type = type;
        this.currency = currency;
        this.tradableAmount = tradableAmount;
        this.dayPeriod = dayPeriod;
        this.id = id;
        this.timestamp = timestamp;
    }

    public Order.OrderType getType() {
        return this.type;
    }

    public String getCurrency() {
        return this.currency;
    }

    public BigDecimal getTradableAmount() {
        return this.tradableAmount;
    }

    public int getDayPeriod() {
        return this.dayPeriod;
    }

    public String getId() {
        return this.id;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "LoanOrder [type=" + (Object)((Object)this.type) + ", currency=" + this.currency + ", tradableAmount=" + this.tradableAmount + ", dayPeriod=" + this.dayPeriod + ", id=" + this.id + ", timestamp=" + this.timestamp + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.currency == null ? 0 : this.currency.hashCode());
        result = 31 * result + this.dayPeriod;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        result = 31 * result + (this.tradableAmount == null ? 0 : this.tradableAmount.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LoanOrder other = (LoanOrder)obj;
        if (this.currency == null ? other.currency != null : !this.currency.equals(other.currency)) {
            return false;
        }
        if (this.dayPeriod != other.dayPeriod) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.timestamp == null ? other.timestamp != null : !this.timestamp.equals(other.timestamp)) {
            return false;
        }
        if (this.tradableAmount == null ? other.tradableAmount != null : !this.tradableAmount.equals(other.tradableAmount)) {
            return false;
        }
        return this.type == other.type;
    }
}

