/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.knowm.xchange.currency.CurrencyPair;

public abstract class Order {
    private final OrderType type;
    private OrderStatus status;
    private final BigDecimal tradableAmount;
    private BigDecimal cumulativeAmount;
    private BigDecimal averagePrice;
    private final CurrencyPair currencyPair;
    private final String id;
    private final Date timestamp;
    private final Set<IOrderFlags> flags = new HashSet<IOrderFlags>();

    public Order(OrderType type, BigDecimal tradableAmount, CurrencyPair currencyPair, String id, Date timestamp) {
        this.type = type;
        this.tradableAmount = tradableAmount;
        this.currencyPair = currencyPair;
        this.id = id;
        this.timestamp = timestamp;
        this.averagePrice = BigDecimal.ZERO;
        this.status = OrderStatus.PENDING_NEW;
        this.cumulativeAmount = BigDecimal.ZERO;
    }

    public Order(OrderType type, BigDecimal tradableAmount, CurrencyPair currencyPair, String id, Date timestamp, BigDecimal averagePrice, BigDecimal cumulativeAmount, OrderStatus status) {
        this.type = type;
        this.tradableAmount = tradableAmount;
        this.currencyPair = currencyPair;
        this.id = id;
        this.timestamp = timestamp;
        this.averagePrice = averagePrice;
        this.cumulativeAmount = cumulativeAmount;
        this.status = status;
    }

    public OrderType getType() {
        return this.type;
    }

    public OrderStatus getStatus() {
        return this.status;
    }

    public BigDecimal getTradableAmount() {
        return this.tradableAmount;
    }

    public BigDecimal getCumulativeAmount() {
        return this.cumulativeAmount;
    }

    public BigDecimal getAveragePrice() {
        return this.averagePrice;
    }

    public CurrencyPair getCurrencyPair() {
        return this.currencyPair;
    }

    public String getId() {
        return this.id;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Set<IOrderFlags> getOrderFlags() {
        return this.flags;
    }

    public boolean hasFlag(IOrderFlags flag) {
        return this.flags.contains(flag);
    }

    public void addOrderFlag(IOrderFlags flag) {
        this.flags.add(flag);
    }

    public void setOrderFlags(Set<IOrderFlags> flags) {
        this.flags.clear();
        if (flags != null) {
            this.flags.addAll(flags);
        }
    }

    public void setOrderStatus(OrderStatus status) {
        this.status = status;
    }

    public void setAveragePrice(BigDecimal averagePrice) {
        this.averagePrice = averagePrice;
    }

    public void setCumulativeAmount(BigDecimal cumulativeAmount) {
        this.cumulativeAmount = cumulativeAmount;
    }

    public String toString() {
        return "Order [type=" + (Object)((Object)this.type) + ", tradableAmount=" + this.tradableAmount + ", averagePrice=" + this.averagePrice + ", currencyPair=" + this.currencyPair + ", id=" + this.id + ", timestamp=" + this.timestamp + ", status=" + (Object)((Object)this.status) + "]";
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 83 * hash + (this.tradableAmount != null ? this.tradableAmount.hashCode() : 0);
        hash = 83 * hash + (this.currencyPair != null ? this.currencyPair.hashCode() : 0);
        hash = 83 * hash + (this.id != null ? this.id.hashCode() : 0);
        hash = 83 * hash + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Order other = (Order)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.tradableAmount == null ? other.tradableAmount != null : this.tradableAmount.compareTo(other.tradableAmount) != 0) {
            return false;
        }
        if (this.currencyPair == null ? other.currencyPair != null : !this.currencyPair.equals(other.currencyPair)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return this.timestamp == other.timestamp || this.timestamp != null && this.timestamp.equals(other.timestamp);
    }

    public static abstract class Builder {
        protected OrderType orderType;
        protected BigDecimal tradableAmount;
        protected CurrencyPair currencyPair;
        protected String id;
        protected Date timestamp;
        protected BigDecimal averagePrice;
        protected OrderStatus status;
        protected final Set<IOrderFlags> flags = new HashSet<IOrderFlags>();

        protected Builder(OrderType orderType, CurrencyPair currencyPair) {
            this.orderType = orderType;
            this.currencyPair = currencyPair;
        }

        public Builder orderType(OrderType orderType) {
            this.orderType = orderType;
            return this;
        }

        public Builder orderStatus(OrderStatus status) {
            this.status = status;
            return this;
        }

        public Builder tradableAmount(BigDecimal tradableAmount) {
            this.tradableAmount = tradableAmount;
            return this;
        }

        public Builder averagePrice(BigDecimal averagePrice) {
            this.averagePrice = averagePrice;
            return this;
        }

        public Builder currencyPair(CurrencyPair currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder flags(Set<IOrderFlags> flags) {
            this.flags.addAll(flags);
            return this;
        }

        public Builder flag(IOrderFlags flag) {
            this.flags.add(flag);
            return this;
        }
    }

    public static interface IOrderFlags {
    }

    public static enum OrderStatus {
        PENDING_NEW,
        NEW,
        PARTIALLY_FILLED,
        FILLED,
        PENDING_CANCEL,
        CANCELED,
        PENDING_REPLACE,
        REPLACED,
        STOPPED,
        REJECTED,
        EXPIRED;

    }

    public static enum OrderType {
        BID,
        ASK,
        EXIT_ASK,
        EXIT_BID;

    }
}

