/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.account;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.knowm.xchange.dto.account.Wallet;

public final class AccountInfo {
    private final String username;
    private final BigDecimal tradingFee;
    private final Map<String, Wallet> wallets;

    public AccountInfo(Wallet ... wallets) {
        this(null, (BigDecimal)null, wallets);
    }

    public AccountInfo(Collection<Wallet> wallets) {
        this(null, (BigDecimal)null, wallets);
    }

    public AccountInfo(String username, Wallet ... wallets) {
        this(username, (BigDecimal)null, wallets);
    }

    public AccountInfo(String username, Collection<Wallet> wallets) {
        this(username, null, wallets);
    }

    public AccountInfo(String username, BigDecimal tradingFee, Collection<Wallet> wallets) {
        this.username = username;
        this.tradingFee = tradingFee;
        if (wallets.size() == 0) {
            this.wallets = Collections.emptyMap();
        } else if (wallets.size() == 1) {
            Wallet wallet = wallets.iterator().next();
            this.wallets = Collections.singletonMap(wallet.getId(), wallet);
        } else {
            this.wallets = new HashMap<String, Wallet>();
            for (Wallet wallet : wallets) {
                if (this.wallets.containsKey(wallet.getId())) {
                    throw new IllegalArgumentException("duplicate wallets passed to AccountInfo");
                }
                this.wallets.put(wallet.getId(), wallet);
            }
        }
    }

    public AccountInfo(String username, BigDecimal tradingFee, Wallet ... wallets) {
        this(username, tradingFee, Arrays.asList(wallets));
    }

    public Map<String, Wallet> getWallets() {
        return Collections.unmodifiableMap(this.wallets);
    }

    public Wallet getWallet() {
        if (this.wallets.size() != 1) {
            throw new UnsupportedOperationException(this.wallets.size() + " wallets in account");
        }
        return this.getWallet(this.wallets.keySet().iterator().next());
    }

    public Wallet getWallet(String id) {
        return this.wallets.get(id);
    }

    public String getUsername() {
        return this.username;
    }

    public BigDecimal getTradingFee() {
        return this.tradingFee;
    }

    public String toString() {
        return "AccountInfo [username=" + this.username + ", tradingFee=" + this.tradingFee + ", wallets=" + this.wallets + "]";
    }
}

