/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.account;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.knowm.xchange.currency.Currency;

public final class FundingRecord {
    private final String address;
    private final Date date;
    private final Currency currency;
    private final BigDecimal amount;
    private final String internalId;
    private final String externalId;
    private String description;
    private final Type type;
    private final Status status;
    private final BigDecimal balance;
    private final BigDecimal fee;

    @Deprecated
    public FundingRecord(String address, Date date, Currency currency, BigDecimal amount, String internalId, String externalId, Type type, String status, BigDecimal balance, BigDecimal fee, String description) {
        this(address, date, currency, amount, internalId, externalId, type, Status.resolveStatus(status), balance, fee, description);
        if (this.status == null && status != null) {
            this.description = this.description == null || this.description.isEmpty() ? status : status + ": " + this.description;
        }
    }

    public FundingRecord(String address, Date date, Currency currency, BigDecimal amount, String internalId, String externalId, Type type, Status status, BigDecimal balance, BigDecimal fee, String description) {
        this.address = address;
        this.date = date;
        this.currency = currency;
        this.amount = amount == null ? null : amount.abs();
        this.internalId = internalId;
        this.externalId = externalId;
        this.type = type;
        this.status = status;
        this.balance = balance;
        this.fee = fee == null ? null : fee.abs();
        this.description = description;
    }

    public String getAddress() {
        return this.address;
    }

    public Date getDate() {
        return this.date;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String getInternalId() {
        return this.internalId;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public Type getType() {
        return this.type;
    }

    public Status getStatus() {
        return this.status;
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public BigDecimal getFee() {
        return this.fee;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return String.format("FundingRecord{address='%s', date=%s, currency=%s, amount=%s, internalId=%s, externalId=%s, description='%s', type=%s, status=%s, balance=%s, fee=%s}", new Object[]{this.address, this.date, this.currency, this.amount, this.internalId, this.externalId, this.description, this.type, this.status, this.balance, this.fee});
    }

    public static enum Status {
        PROCESSING("WAIT CONFIRMATION", "EMAIL CONFIRMATION", "EMAIL SENT", "AWAITING APPROVAL", "VERIFYING", "PENDING_APPROVAL", "PENDING"),
        COMPLETE("COMPLETED"),
        CANCELLED("REVOKED", "CANCEL", "REFUND"),
        FAILED("FAILURE");

        private String[] statusArray;
        private static final Map<String, Status> fromString;

        private Status(String ... statusArray) {
            this.statusArray = statusArray;
        }

        public static Status resolveStatus(String str) {
            if (str == null) {
                return null;
            }
            return fromString.get(str.toUpperCase());
        }

        static {
            fromString = new HashMap<String, Status>();
            for (Status status : Status.values()) {
                String[] statusArray = status.statusArray;
                if (statusArray != null) {
                    for (String statusStr : statusArray) {
                        fromString.put(statusStr, status);
                    }
                }
                fromString.put(status.toString(), status);
            }
        }
    }

    public static enum Type {
        WITHDRAWAL,
        DEPOSIT;

        private static final Map<String, Type> fromString;

        public static Type fromString(String ledgerTypeString) {
            return fromString.get(ledgerTypeString.toUpperCase());
        }

        static {
            fromString = new HashMap<String, Type>();
            for (Type type : Type.values()) {
                fromString.put(type.toString(), type);
            }
        }
    }
}

