/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.account;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.Balance;

public final class Wallet {
    private String id;
    private String name;
    private final Map<Currency, Balance> balances;

    public Wallet(String id, String name, Collection<Balance> balances) {
        this.id = id;
        this.name = name == null ? id : name;
        if (balances.size() == 0) {
            this.balances = Collections.emptyMap();
        } else if (balances.size() == 1) {
            Balance balance = balances.iterator().next();
            this.balances = Collections.singletonMap(balance.getCurrency(), balance);
        } else {
            this.balances = new HashMap<Currency, Balance>();
            for (Balance balance : balances) {
                if (this.balances.containsKey(balance.getCurrency())) {
                    throw new IllegalArgumentException("duplicate balances in wallet");
                }
                this.balances.put(balance.getCurrency(), balance);
            }
        }
    }

    public Wallet(String id, Collection<Balance> balances) {
        this(id, null, balances);
    }

    public Wallet(String id, Balance ... balances) {
        this(id, null, Arrays.asList(balances));
    }

    public Wallet(Collection<Balance> balances) {
        this(null, null, balances);
    }

    public Wallet(Balance ... balances) {
        this((String)null, balances);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Map<Currency, Balance> getBalances() {
        return Collections.unmodifiableMap(this.balances);
    }

    public Balance getBalance(Currency currency) {
        Balance balance = this.balances.get(currency);
        return balance == null ? Balance.zero(currency) : balance;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Wallet)) {
            return false;
        }
        Wallet wallet = (Wallet)object;
        return Objects.equals(this.id, wallet.id) && Objects.equals(this.name, wallet.name) && this.balances.equals(wallet.balances);
    }

    public String toString() {
        return "Wallet [id=" + this.id + ", name=" + this.name + ", balances=" + this.balances.values() + "]";
    }
}

