/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.marketdata;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.OrderBookUpdate;
import org.knowm.xchange.dto.trade.LimitOrder;

public final class OrderBook {
    private Date timeStamp;
    private final List<LimitOrder> asks;
    private final List<LimitOrder> bids;

    public OrderBook(Date timeStamp, List<LimitOrder> asks, List<LimitOrder> bids) {
        this.timeStamp = timeStamp;
        this.asks = asks;
        this.bids = bids;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public List<LimitOrder> getAsks() {
        return this.asks;
    }

    public List<LimitOrder> getBids() {
        return this.bids;
    }

    public List<LimitOrder> getOrders(Order.OrderType type) {
        return type == Order.OrderType.ASK ? this.asks : this.bids;
    }

    public void update(LimitOrder limitOrder) {
        this.update(this.getOrders(limitOrder.getType()), limitOrder);
        this.updateDate(limitOrder.getTimestamp());
    }

    private void update(List<LimitOrder> asks, LimitOrder limitOrder) {
        int idx = Collections.binarySearch(asks, limitOrder);
        if (idx >= 0) {
            asks.remove(idx);
            asks.add(idx, limitOrder);
        } else {
            asks.add(-idx - 1, limitOrder);
        }
    }

    public void update(OrderBookUpdate orderBookUpdate) {
        LimitOrder limitOrder = orderBookUpdate.getLimitOrder();
        List<LimitOrder> limitOrders = this.getOrders(limitOrder.getType());
        int idx = Collections.binarySearch(limitOrders, limitOrder);
        if (idx >= 0) {
            limitOrders.remove(idx);
        } else {
            idx = -idx - 1;
        }
        if (orderBookUpdate.getTotalVolume().compareTo(BigDecimal.ZERO) != 0) {
            LimitOrder updatedOrder = OrderBook.withAmount(limitOrder, orderBookUpdate.getTotalVolume());
            limitOrders.add(idx, updatedOrder);
        }
        this.updateDate(limitOrder.getTimestamp());
    }

    private static LimitOrder withAmount(LimitOrder limitOrder, BigDecimal tradeableAmount) {
        Order.OrderType type = limitOrder.getType();
        CurrencyPair currencyPair = limitOrder.getCurrencyPair();
        String id = limitOrder.getId();
        Date date = limitOrder.getTimestamp();
        BigDecimal limit = limitOrder.getLimitPrice();
        return new LimitOrder(type, tradeableAmount, currencyPair, id, date, limit);
    }

    private void updateDate(Date updateDate) {
        if (updateDate != null && (this.timeStamp == null || updateDate.after(this.timeStamp))) {
            this.timeStamp = updateDate;
        }
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + (this.timeStamp != null ? this.timeStamp.hashCode() : 0);
        for (LimitOrder order : this.bids) {
            hash = 31 * hash + order.hashCode();
        }
        for (LimitOrder order : this.asks) {
            hash = 31 * hash + order.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        int index;
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrderBook other = (OrderBook)obj;
        if (this.timeStamp == null ? other.timeStamp != null : !this.timeStamp.equals(other.timeStamp)) {
            return false;
        }
        if (this.bids.size() != other.bids.size()) {
            return false;
        }
        for (index = 0; index < this.bids.size(); ++index) {
            if (this.bids.get(index).equals(other.bids.get(index))) continue;
            return false;
        }
        if (this.asks.size() != other.asks.size()) {
            return false;
        }
        for (index = 0; index < this.asks.size(); ++index) {
            if (this.asks.get(index).equals(other.asks.get(index))) continue;
            return false;
        }
        return true;
    }

    public boolean ordersEqual(OrderBook ob) {
        Date timestamp = new Date();
        if (this != null && ob != null) {
            OrderBook thisOb = new OrderBook(timestamp, this.getAsks(), this.getBids());
            OrderBook thatOb = new OrderBook(timestamp, ob.getAsks(), ob.getBids());
            return thisOb.equals(thatOb);
        }
        return this.equals(ob);
    }

    public String toString() {
        return "OrderBook [timestamp: " + this.timeStamp + ", asks=" + this.asks.toString() + ", bids=" + this.bids.toString() + "]";
    }
}

