/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.marketdata;

import java.math.BigDecimal;
import java.util.Date;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.utils.DateUtils;

public final class Ticker {
    private final CurrencyPair currencyPair;
    private final BigDecimal last;
    private final BigDecimal bid;
    private final BigDecimal ask;
    private final BigDecimal high;
    private final BigDecimal low;
    private final BigDecimal vwap;
    private final BigDecimal volume;
    private final Date timestamp;

    private Ticker(CurrencyPair currencyPair, BigDecimal last, BigDecimal bid, BigDecimal ask, BigDecimal high, BigDecimal low, BigDecimal vwap, BigDecimal volume, Date timestamp) {
        this.currencyPair = currencyPair;
        this.last = last;
        this.bid = bid;
        this.ask = ask;
        this.high = high;
        this.low = low;
        this.vwap = vwap;
        this.volume = volume;
        this.timestamp = timestamp;
    }

    public CurrencyPair getCurrencyPair() {
        return this.currencyPair;
    }

    public BigDecimal getLast() {
        return this.last;
    }

    public BigDecimal getBid() {
        return this.bid;
    }

    public BigDecimal getAsk() {
        return this.ask;
    }

    public BigDecimal getHigh() {
        return this.high;
    }

    public BigDecimal getLow() {
        return this.low;
    }

    public BigDecimal getVwap() {
        return this.vwap;
    }

    public BigDecimal getVolume() {
        return this.volume;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "Ticker [currencyPair=" + this.currencyPair + ", last=" + this.last + ", bid=" + this.bid + ", ask=" + this.ask + ", high=" + this.high + ", low=" + this.low + ",avg=" + this.vwap + ", volume=" + this.volume + ", timestamp=" + DateUtils.toMillisNullSafe(this.timestamp) + "]";
    }

    public static class Builder {
        private CurrencyPair currencyPair;
        private BigDecimal last;
        private BigDecimal bid;
        private BigDecimal ask;
        private BigDecimal high;
        private BigDecimal low;
        private BigDecimal vwap;
        private BigDecimal volume;
        private Date timestamp;
        private boolean isBuilt = false;

        public Ticker build() {
            this.validateState();
            Ticker ticker = new Ticker(this.currencyPair, this.last, this.bid, this.ask, this.high, this.low, this.vwap, this.volume, this.timestamp);
            this.isBuilt = true;
            return ticker;
        }

        private void validateState() {
            if (this.isBuilt) {
                throw new IllegalStateException("The entity has been built");
            }
        }

        public Builder currencyPair(CurrencyPair currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        public Builder last(BigDecimal last) {
            this.last = last;
            return this;
        }

        public Builder bid(BigDecimal bid) {
            this.bid = bid;
            return this;
        }

        public Builder ask(BigDecimal ask) {
            this.ask = ask;
            return this;
        }

        public Builder high(BigDecimal high) {
            this.high = high;
            return this;
        }

        public Builder low(BigDecimal low) {
            this.low = low;
            return this;
        }

        public Builder vwap(BigDecimal vwap) {
            this.vwap = vwap;
            return this;
        }

        public Builder volume(BigDecimal volume) {
            this.volume = volume;
            return this;
        }

        public Builder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }
    }
}

