/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.marketdata;

import java.math.BigDecimal;
import java.util.Date;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;

public class Trade {
    protected final Order.OrderType type;
    protected final BigDecimal tradableAmount;
    protected final CurrencyPair currencyPair;
    protected final BigDecimal price;
    protected final Date timestamp;
    protected final String id;

    public Trade(Order.OrderType type, BigDecimal tradableAmount, CurrencyPair currencyPair, BigDecimal price, Date timestamp, String id) {
        this.type = type;
        this.tradableAmount = tradableAmount;
        this.currencyPair = currencyPair;
        this.price = price;
        this.timestamp = timestamp;
        this.id = id;
    }

    public Order.OrderType getType() {
        return this.type;
    }

    public BigDecimal getTradableAmount() {
        return this.tradableAmount;
    }

    public CurrencyPair getCurrencyPair() {
        return this.currencyPair;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.id.equals(((Trade)o).getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "Trade [type=" + (Object)((Object)this.type) + ", tradableAmount=" + this.tradableAmount + ", currencyPair=" + this.currencyPair + ", price=" + this.price + ", timestamp=" + this.timestamp + ", id=" + this.id + "]";
    }

    public static class Builder {
        protected Order.OrderType type;
        protected BigDecimal tradableAmount;
        protected CurrencyPair currencyPair;
        protected BigDecimal price;
        protected Date timestamp;
        protected String id;

        public static Builder from(Trade trade) {
            return new Builder().type(trade.getType()).tradableAmount(trade.getTradableAmount()).currencyPair(trade.getCurrencyPair()).price(trade.getPrice()).timestamp(trade.getTimestamp()).id(trade.getId());
        }

        public Builder type(Order.OrderType type) {
            this.type = type;
            return this;
        }

        public Builder tradableAmount(BigDecimal tradableAmount) {
            this.tradableAmount = tradableAmount;
            return this;
        }

        public Builder currencyPair(CurrencyPair currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        public Builder price(BigDecimal price) {
            this.price = price;
            return this;
        }

        public Builder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Trade build() {
            return new Trade(this.type, this.tradableAmount, this.currencyPair, this.price, this.timestamp, this.id);
        }
    }
}

