/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.marketdata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.knowm.xchange.dto.marketdata.Trade;

public class Trades {
    private static final TradeIDComparator TRADE_ID_COMPARATOR = new TradeIDComparator();
    private static final TradeTimestampComparator TRADE_TIMESTAMP_COMPARATOR = new TradeTimestampComparator();
    private final List<Trade> trades;
    private final long lastID;
    private final TradeSortType tradeSortType;

    public Trades(List<Trade> trades, TradeSortType tradeSortType) {
        this(trades, 0L, tradeSortType);
    }

    public Trades(List<Trade> trades, long lastID, TradeSortType tradeSortType) {
        this.trades = new ArrayList<Trade>(trades);
        this.lastID = lastID;
        this.tradeSortType = tradeSortType;
        switch (tradeSortType) {
            case SortByTimestamp: {
                Collections.sort(this.trades, TRADE_TIMESTAMP_COMPARATOR);
                break;
            }
            case SortByID: {
                Collections.sort(this.trades, TRADE_ID_COMPARATOR);
                break;
            }
        }
    }

    public List<Trade> getTrades() {
        return this.trades;
    }

    public long getlastID() {
        return this.lastID;
    }

    public TradeSortType getTradeSortType() {
        return this.tradeSortType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Trades\n");
        sb.append("lastID= " + this.lastID + "\n");
        for (Trade trade : this.getTrades()) {
            sb.append("[trade=");
            sb.append(trade.toString());
            sb.append("]\n");
        }
        return sb.toString();
    }

    public static class TradeIDComparator
    implements Comparator<Trade> {
        @Override
        public int compare(Trade trade1, Trade trade2) {
            return trade1.getId().compareTo(trade2.getId());
        }
    }

    public static class TradeTimestampComparator
    implements Comparator<Trade> {
        @Override
        public int compare(Trade trade1, Trade trade2) {
            return trade1.getTimestamp().compareTo(trade2.getTimestamp());
        }
    }

    public static enum TradeSortType {
        SortByTimestamp,
        SortByID;

    }
}

