/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.meta;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class RateLimit {
    @JsonProperty(value="calls")
    public int calls = 1;
    @JsonProperty(value="time_span")
    public int timeSpan = 1;
    @JsonProperty(value="time_unit")
    @JsonDeserialize(using=TimeUnitDeserializer.class)
    public TimeUnit timeUnit = TimeUnit.SECONDS;

    public RateLimit() {
    }

    public RateLimit(@JsonProperty(value="calls") int calls, @JsonProperty(value="time_span") int timeSpan, @JsonProperty(value="time_unit") @JsonDeserialize(using=TimeUnitDeserializer.class) TimeUnit timeUnit) {
        this.calls = calls;
        this.timeUnit = timeUnit;
        this.timeSpan = timeSpan;
    }

    @JsonIgnore
    public long getPollDelayMillis() {
        return this.timeUnit.toMillis(this.timeSpan) / (long)this.calls;
    }

    public String toString() {
        return "RateLimit [calls=" + this.calls + ", timeSpan=" + this.timeSpan + ", timeUnit=" + (Object)((Object)this.timeUnit) + "]";
    }

    public static class TimeUnitDeserializer
    extends JsonDeserializer<TimeUnit> {
        public TimeUnit deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            return TimeUnit.valueOf(jp.getValueAsString().toUpperCase());
        }
    }
}

