/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.trade;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;

public class LimitOrder
extends Order
implements Comparable<LimitOrder> {
    protected final BigDecimal limitPrice;

    public LimitOrder(Order.OrderType type, BigDecimal tradableAmount, CurrencyPair currencyPair, String id, Date timestamp, BigDecimal limitPrice) {
        super(type, tradableAmount, currencyPair, id, timestamp);
        this.limitPrice = limitPrice;
    }

    public LimitOrder(Order.OrderType type, BigDecimal tradableAmount, CurrencyPair currencyPair, String id, Date timestamp, BigDecimal limitPrice, BigDecimal averagePrice, BigDecimal cumulativeAmount, Order.OrderStatus status) {
        super(type, tradableAmount, currencyPair, id, timestamp, averagePrice, cumulativeAmount, status);
        this.limitPrice = limitPrice;
    }

    public BigDecimal getLimitPrice() {
        return this.limitPrice;
    }

    @Override
    public String toString() {
        return "LimitOrder [limitPrice=" + this.limitPrice + ", " + super.toString() + "]";
    }

    @Override
    public int compareTo(LimitOrder limitOrder) {
        int ret = this.getType() == limitOrder.getType() ? this.getLimitPrice().compareTo(limitOrder.getLimitPrice()) * (this.getType() == Order.OrderType.BID ? -1 : 1) : (this.getType() == Order.OrderType.BID ? -1 : 1);
        return ret;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 59 * hash + (this.limitPrice != null ? this.limitPrice.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LimitOrder other = (LimitOrder)obj;
        if (this.limitPrice == null ? other.limitPrice != null : this.limitPrice.compareTo(other.limitPrice) != 0) {
            return false;
        }
        return super.equals(obj);
    }

    public static class Builder
    extends Order.Builder {
        protected BigDecimal limitPrice;

        public Builder(Order.OrderType orderType, CurrencyPair currencyPair) {
            super(orderType, currencyPair);
        }

        public static Builder from(Order order) {
            Builder builder = ((Builder)new Builder(order.getType(), order.getCurrencyPair()).tradableAmount(order.getTradableAmount()).timestamp(order.getTimestamp()).id(order.getId()).flags((Set)order.getOrderFlags())).orderStatus(order.getStatus()).averagePrice(order.getAveragePrice());
            if (order instanceof LimitOrder) {
                LimitOrder limitOrder = (LimitOrder)order;
                builder.limitPrice(limitOrder.getLimitPrice());
            }
            return builder;
        }

        @Override
        public Builder orderType(Order.OrderType orderType) {
            return (Builder)super.orderType(orderType);
        }

        @Override
        public Builder tradableAmount(BigDecimal tradableAmount) {
            return (Builder)super.tradableAmount(tradableAmount);
        }

        @Override
        public Builder currencyPair(CurrencyPair currencyPair) {
            return (Builder)super.currencyPair(currencyPair);
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder timestamp(Date timestamp) {
            return (Builder)super.timestamp(timestamp);
        }

        @Override
        public Builder orderStatus(Order.OrderStatus status) {
            return (Builder)super.orderStatus(status);
        }

        @Override
        public Builder averagePrice(BigDecimal averagePrice) {
            return (Builder)super.averagePrice(averagePrice);
        }

        @Override
        public Builder flag(Order.IOrderFlags flag) {
            return (Builder)super.flag(flag);
        }

        @Override
        public Builder flags(Set<Order.IOrderFlags> flags) {
            return (Builder)super.flags(flags);
        }

        public Builder limitPrice(BigDecimal limitPrice) {
            this.limitPrice = limitPrice;
            return this;
        }

        public LimitOrder build() {
            LimitOrder order = new LimitOrder(this.orderType, this.tradableAmount, this.currencyPair, this.id, this.timestamp, this.limitPrice, this.averagePrice, null, this.status);
            order.setOrderFlags(this.flags);
            return order;
        }
    }
}

