/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.trade;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;

public class MarketOrder
extends Order {
    public MarketOrder(Order.OrderType type, BigDecimal tradableAmount, CurrencyPair currencyPair, String id, Date timestamp, BigDecimal averagePrice, BigDecimal cumulativeAmount, Order.OrderStatus status) {
        super(type, tradableAmount, currencyPair, id, timestamp, averagePrice, cumulativeAmount, status);
    }

    public MarketOrder(Order.OrderType type, BigDecimal tradableAmount, CurrencyPair currencyPair, String id, Date timestamp) {
        super(type, tradableAmount, currencyPair, id, timestamp);
    }

    public MarketOrder(Order.OrderType type, BigDecimal tradableAmount, CurrencyPair currencyPair, Date timestamp) {
        super(type, tradableAmount, currencyPair, "", timestamp);
    }

    public MarketOrder(Order.OrderType type, BigDecimal tradableAmount, CurrencyPair currencyPair) {
        super(type, tradableAmount, currencyPair, "", null);
    }

    public static class Builder
    extends Order.Builder {
        public Builder(Order.OrderType orderType, CurrencyPair currencyPair) {
            super(orderType, currencyPair);
        }

        public static Builder from(Order order) {
            return ((Builder)new Builder(order.getType(), order.getCurrencyPair()).tradableAmount(order.getTradableAmount()).timestamp(order.getTimestamp()).id(order.getId()).flags((Set)order.getOrderFlags())).averagePrice(order.getAveragePrice()).orderStatus(order.getStatus());
        }

        @Override
        public Builder orderType(Order.OrderType orderType) {
            return (Builder)super.orderType(orderType);
        }

        @Override
        public Builder orderStatus(Order.OrderStatus status) {
            return (Builder)super.orderStatus(status);
        }

        @Override
        public Builder averagePrice(BigDecimal averagePrice) {
            return (Builder)super.averagePrice(averagePrice);
        }

        @Override
        public Builder tradableAmount(BigDecimal tradableAmount) {
            return (Builder)super.tradableAmount(tradableAmount);
        }

        @Override
        public Builder currencyPair(CurrencyPair currencyPair) {
            return (Builder)super.currencyPair(currencyPair);
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder timestamp(Date timestamp) {
            return (Builder)super.timestamp(timestamp);
        }

        @Override
        public Builder flags(Set<Order.IOrderFlags> flags) {
            return (Builder)super.flags(flags);
        }

        @Override
        public Builder flag(Order.IOrderFlags flag) {
            return (Builder)super.flag(flag);
        }

        public MarketOrder build() {
            MarketOrder order = new MarketOrder(this.orderType, this.tradableAmount, this.currencyPair, this.id, this.timestamp, this.averagePrice, null, this.status);
            order.setOrderFlags(this.flags);
            return order;
        }
    }
}

