/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.trade;

import java.math.BigDecimal;
import java.util.Date;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.Trade;

public class UserTrade
extends Trade {
    private final String orderId;
    private final BigDecimal feeAmount;
    private final Currency feeCurrency;

    public UserTrade(Order.OrderType type, BigDecimal tradableAmount, CurrencyPair currencyPair, BigDecimal price, Date timestamp, String id, String orderId, BigDecimal feeAmount, Currency feeCurrency) {
        super(type, tradableAmount, currencyPair, price, timestamp, id);
        this.orderId = orderId;
        this.feeAmount = feeAmount;
        this.feeCurrency = feeCurrency;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public BigDecimal getFeeAmount() {
        return this.feeAmount;
    }

    public Currency getFeeCurrency() {
        return this.feeCurrency;
    }

    @Override
    public String toString() {
        return "UserTrade[type=" + (Object)((Object)this.type) + ", tradableAmount=" + this.tradableAmount + ", currencyPair=" + this.currencyPair + ", price=" + this.price + ", timestamp=" + this.timestamp + ", id=" + this.id + ", orderId='" + this.orderId + '\'' + ", feeAmount=" + this.feeAmount + ", feeCurrency='" + this.feeCurrency + '\'' + "]";
    }

    public static class Builder
    extends Trade.Builder {
        protected String orderId;
        protected BigDecimal feeAmount;
        protected Currency feeCurrency;

        public static Builder from(UserTrade trade) {
            return new Builder().type(trade.getType()).tradableAmount(trade.getTradableAmount()).currencyPair(trade.getCurrencyPair()).price(trade.getPrice()).timestamp(trade.getTimestamp()).id(trade.getId()).orderId(trade.getOrderId()).feeAmount(trade.getFeeAmount()).feeCurrency(trade.getFeeCurrency());
        }

        @Override
        public Builder type(Order.OrderType type) {
            return (Builder)super.type(type);
        }

        @Override
        public Builder tradableAmount(BigDecimal tradableAmount) {
            return (Builder)super.tradableAmount(tradableAmount);
        }

        @Override
        public Builder currencyPair(CurrencyPair currencyPair) {
            return (Builder)super.currencyPair(currencyPair);
        }

        @Override
        public Builder price(BigDecimal price) {
            return (Builder)super.price(price);
        }

        @Override
        public Builder timestamp(Date timestamp) {
            return (Builder)super.timestamp(timestamp);
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        public Builder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public Builder feeAmount(BigDecimal feeAmount) {
            this.feeAmount = feeAmount;
            return this;
        }

        public Builder feeCurrency(Currency feeCurrency) {
            this.feeCurrency = feeCurrency;
            return this;
        }

        @Override
        public UserTrade build() {
            return new UserTrade(this.type, this.tradableAmount, this.currencyPair, this.price, this.timestamp, this.id, this.orderId, this.feeAmount, this.feeCurrency);
        }
    }
}

